/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.fluid_generators.IFluidGenerator;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import com.ordana.immersive_weathering.util.StrOpt;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.Fluid;

public class OtherFluidGenerator
implements IFluidGenerator {
    public static final Codec<OtherFluidGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("fluid").forGetter(OtherFluidGenerator::getFluid), (App)StrOpt.of(IFluidGenerator.FluidType.CODEC, "fluid_type", IFluidGenerator.FluidType.BOTH).forGetter(OtherFluidGenerator::getFluidType), (App)BlockState.f_61039_.fieldOf("generate").forGetter(OtherFluidGenerator::getGrowth), (App)RuleTest.f_74307_.fieldOf("target").forGetter(OtherFluidGenerator::getTarget), (App)StrOpt.of(IPositionRuleTest.CODEC, "additional_target_check").forGetter(OtherFluidGenerator::getExtraCheck), (App)StrOpt.of(Codec.INT, "priority", 0).forGetter(OtherFluidGenerator::getPriority)).apply((Applicative)instance, OtherFluidGenerator::new));
    public static final IFluidGenerator.Type<OtherFluidGenerator> TYPE = new IFluidGenerator.Type<OtherFluidGenerator>(CODEC, "target_other");
    private final Fluid fluid;
    private final IFluidGenerator.FluidType fluidType;
    private final BlockState growth;
    private final RuleTest target;
    private final Optional<IPositionRuleTest> extraCheck;
    private final int priority;

    public OtherFluidGenerator(Fluid fluid, IFluidGenerator.FluidType fluidType, BlockState growth, RuleTest target, Optional<IPositionRuleTest> positionRuleTests, int priority) {
        this.fluid = fluid;
        this.fluidType = fluidType;
        this.growth = growth;
        this.target = target;
        this.extraCheck = positionRuleTests;
        this.priority = priority;
    }

    @Override
    public IFluidGenerator.FluidType getFluidType() {
        return this.fluidType;
    }

    @Override
    public IFluidGenerator.Type<?> getType() {
        return TYPE;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    public RuleTest getTarget() {
        return this.target;
    }

    public BlockState getGrowth() {
        return this.growth;
    }

    public Optional<IPositionRuleTest> getExtraCheck() {
        return this.extraCheck;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Optional<BlockPos> tryGenerating(List<Direction> possibleFlowDir, BlockPos pos, Level level, Map<Direction, BlockState> neighborCache) {
        Supplier b = Suppliers.memoize(() -> level.m_204166_(pos));
        for (Direction d : possibleFlowDir) {
            BlockPos p;
            BlockState state = neighborCache.computeIfAbsent(d, arg_0 -> OtherFluidGenerator.lambda$tryGenerating$2(level, p = pos.m_121945_(d), arg_0));
            if (!this.target.m_213865_(state, level.f_46441_) || this.extraCheck.isPresent() && !this.extraCheck.get().test((java.util.function.Supplier<Holder<Biome>>)b, p, level)) continue;
            level.m_46597_(p, this.growth);
            return Optional.of(p);
        }
        return Optional.empty();
    }

    private static /* synthetic */ BlockState lambda$tryGenerating$2(Level level, BlockPos p, Direction c) {
        return level.m_8055_(p);
    }
}

