/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.dynamicpack;

import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class ServerDynamicResourcesHandler
extends DynServerResourcesGenerator {
    public static final ServerDynamicResourcesHandler INSTANCE = new ServerDynamicResourcesHandler();

    public ServerDynamicResourcesHandler() {
        super(new DynamicDataPack(ImmersiveWeathering.res("generated_pack")));
        ((DynamicDataPack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return ImmersiveWeathering.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        SimpleTagBuilder tag = SimpleTagBuilder.of((ResourceLocation)ImmersiveWeathering.res("leaf_piles"));
        tag.addEntries(ModBlocks.LEAF_PILES.values());
        ((DynamicDataPack)this.dynamicPack).addTag(tag, Registries.f_256747_);
        ((DynamicDataPack)this.dynamicPack).addTag(tag, Registries.f_256747_);
        ((DynamicDataPack)this.dynamicPack).addTag(SimpleTagBuilder.of((ResourceLocation)ImmersiveWeathering.res("bark")).addEntries(ModItems.BARK.values()), Registries.f_256913_);
        StaticResource lootTable = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_LOOT_TABLES.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        StaticResource recipe = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        for (Map.Entry<LeavesType, LeafPileBlock> e : ModBlocks.LEAF_PILES.entrySet()) {
            LeavesType leafType = e.getKey();
            if (leafType.isVanilla()) continue;
            LeavesType v = e.getKey();
            String path = leafType.getNamespace() + "/" + leafType.getTypeName();
            String id = path + "_leaf_pile";
            String leavesId = Utils.getID((Block)leafType.leaves).toString();
            try {
                this.addLeafPileJson(Objects.requireNonNull(lootTable), id, leavesId);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile loot table for {} : {}", (Object)v, (Object)ex);
            }
            try {
                this.addLeafPileJson(Objects.requireNonNull(recipe), id, leavesId);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile recipe for {} : {}", (Object)v, (Object)ex);
            }
        }
    }

    public void addLeafPileJson(StaticResource resource, String id, String leafBlockId) {
        String string = new String(resource.data, StandardCharsets.UTF_8);
        String path = resource.location.m_135815_().replace("oak_leaf_pile", id);
        string = string.replace("oak_leaf_pile", id);
        string = string.replace("minecraft:oak_leaves", leafBlockId);
        ResourceLocation newRes = ImmersiveWeathering.res(path);
        ((DynamicDataPack)this.dynamicPack).addBytes(newRes, string.getBytes(), ResType.GENERIC);
    }
}

