/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidfog;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="voidfog")
public class VoidFog {
    static boolean active;
    static final float[] colors;
    static float color;
    static float fog;
    public static final ResourceKey<Level> WORLD_KEY_VOID;

    public VoidFog() {
        IEventBus busForge = MinecraftForge.EVENT_BUS;
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPair.getRight());
        Config.INSTANCE = (Config)specPair.getLeft();
        busForge.addListener(event -> {
            if (active || fog < 1.0f) {
                float f = ((Double)Config.INSTANCE.distance.get()).floatValue();
                float f2 = f = f >= event.getFarPlaneDistance() ? event.getFarPlaneDistance() : Mth.m_144920_((float)f, (float)event.getFarPlaneDistance(), (float)fog);
                float shift = (float)((double)(active ? (fog > 0.5f ? 0.005f : 0.001f) : (fog > 0.25f ? 0.01f : 0.001f)) * event.getPartialTick());
                fog = active ? (fog -= shift) : (fog += shift);
                fog = Mth.m_14036_((float)fog, (float)0.0f, (float)1.0f);
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)f);
            }
        });
        busForge.addListener(event -> {
            if (active || color > 0.0f) {
                float[] realColors = new float[]{event.getRed(), event.getGreen(), event.getBlue()};
                for (int i = 0; i < 3; ++i) {
                    float real = realColors[i];
                    float c = 0.0f;
                    VoidFog.colors[i] = real == 0.0f ? 0.0f : Mth.m_144920_((float)real, (float)0.0f, (float)color);
                }
                color = active ? (color += (float)((double)0.1f * event.getPartialTick())) : (color -= (float)((double)0.005f * event.getPartialTick()));
                color = Mth.m_14036_((float)color, (float)0.0f, (float)1.0f);
                event.setRed(colors[0]);
                event.setGreen(colors[1]);
                event.setBlue(colors[2]);
            }
        });
        busForge.addListener(event -> {
            if (event.player != Minecraft.m_91087_().f_91074_) {
                return;
            }
            if (event.player.m_9236_() != null && event.player.m_20186_() <= (double)(event.player.m_9236_().m_141937_() + (Integer)Config.INSTANCE.y.get()) && ((Boolean)Config.INSTANCE.whitelistToggle.get()).booleanValue() == ((List)Config.INSTANCE.blacklistedDims.get()).contains(event.player.m_9236_().m_46472_().m_135782_().toString()) || VoidFog.checkForVoidscapeDimension(event.player.m_9236_())) {
                active = !event.player.m_21023_(MobEffects.f_19611_);
                RandomSource random = event.player.m_217043_();
                for (int l = 0; l < 100; ++l) {
                    int i1 = event.player.m_20183_().m_123341_() + random.m_188503_(16) - random.m_188503_(16);
                    int j1 = event.player.m_20183_().m_123342_() + random.m_188503_(16) - random.m_188503_(16);
                    int k1 = event.player.m_20183_().m_123343_() + random.m_188503_(16) - random.m_188503_(16);
                    BlockState block = event.player.m_9236_().m_8055_(new BlockPos(i1, j1, k1));
                    if (!block.m_60795_() || random.m_188503_(((Integer)Config.INSTANCE.y.get()).intValue()) <= j1) continue;
                    event.player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, (double)((float)i1 + random.m_188501_()), (double)((float)j1 + random.m_188501_()), (double)((float)k1 + random.m_188501_()), 0.0, 0.0, 0.0);
                }
            } else {
                active = false;
            }
        });
    }

    public static boolean checkForVoidscapeDimension(Level world) {
        return (Boolean)Config.INSTANCE.voidscape.get() != false && world.m_46472_().m_135782_().equals((Object)WORLD_KEY_VOID.m_135782_());
    }

    static {
        colors = new float[3];
        color = 0.0f;
        fog = 1.0f;
        WORLD_KEY_VOID = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("voidscape", "void"));
    }

    static class Config {
        static Config INSTANCE;
        ForgeConfigSpec.IntValue y;
        ForgeConfigSpec.DoubleValue distance;
        ForgeConfigSpec.BooleanValue voidscape;
        ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedDims;
        ForgeConfigSpec.BooleanValue whitelistToggle;

        public Config(ForgeConfigSpec.Builder builder) {
            this.y = builder.translation("voidfog.config.y").comment("The Y value in which void fog takes effect. (Min World Height + Y Value)").defineInRange("y", 12, 0, Integer.MAX_VALUE);
            this.distance = builder.translation("voidfog.config.distance").comment("Defines how far away the fog should be from your player. Higher numbers mean further away.").defineInRange("distance", 30.0, 0.0, Double.MAX_VALUE);
            this.voidscape = builder.translation("voidfog.config.voidscape").comment("Enable the effect everywhere in the mod Voidscape's main Dimension.").define("voidscape", true);
            this.blacklistedDims = builder.translation("voidfog.config.blacklisted_dims").comment("Defines which dimensions shouldnt render any void fog. Each entry should be a valid dimension id. For example, to blacklist void fog from appearing in Twilight Forest, add \"twilightforest:twilight_forest\" to this list.").defineList("dimension_blacklist", new ArrayList(), s -> {
                String string;
                return s instanceof String && ResourceLocation.m_135830_((String)(string = (String)s));
            });
            this.whitelistToggle = builder.translation("voidfog.config.whitelist_toggle").comment("Defines whether the dimension blacklist should function as a whitelist instead, meaning that only dimensions in that config option will render void fog.").define("toggle_whitelist", false);
        }
    }
}

