/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.pillagers_gun.entity.goal;

import com.scarasol.pillagers_gun.item.gun.GunItem;
import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;

public class GunAttackGoal<T extends Mob & CrossbowAttackMob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private GunState gunState = GunState.UNCHARGED;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;
    private int ammoCount;

    public GunAttackGoal(T mob, double speedModifier, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isHoldingGun() && (this.isValidTarget() || !this.hasAmmo());
    }

    private boolean isHoldingGun() {
        return this.mob.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof GunItem;
    }

    public boolean m_8045_() {
        return this.isHoldingGun() && (this.isValidTarget() || !this.hasAmmo());
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public boolean hasAmmo() {
        return GunItem.isCharged(this.mob.m_21120_(InteractionHand.MAIN_HAND));
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            ((CrossbowAttackMob)this.mob).m_6136_(false);
            GunItem.setCharged(this.mob.m_21211_(), false);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        boolean flag = false;
        boolean flag2 = false;
        if (livingentity != null) {
            boolean flag1;
            this.mob.m_21561_(true);
            flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            double d0 = this.mob.m_20280_((Entity)livingentity);
            boolean bl2 = flag2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (flag2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
                }
            } else {
                this.updatePathDelay = 0;
                this.mob.m_21573_().m_26573_();
            }
            this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
        }
        if (this.gunState == GunState.UNCHARGED && GunItem.isCharged(this.mob.m_21120_(InteractionHand.MAIN_HAND))) {
            this.gunState = GunState.CHARGED;
            this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
            this.ammoCount = GunItem.getCurrentAmmoCount(this.mob.m_21120_(InteractionHand.MAIN_HAND));
        }
        if (this.gunState == GunState.CHARGED && !GunItem.isCharged(this.mob.m_21120_(InteractionHand.MAIN_HAND))) {
            this.gunState = GunState.UNCHARGED;
        }
        if (this.gunState == GunState.UNCHARGED) {
            if (!flag2) {
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof GunItem));
                this.gunState = GunState.CHARGING;
                ((CrossbowAttackMob)this.mob).m_6136_(true);
            }
        } else if (this.gunState == GunState.CHARGING) {
            ItemStack itemstack;
            int i;
            if (!this.mob.m_6117_()) {
                this.gunState = GunState.UNCHARGED;
            }
            if ((i = this.mob.m_21252_()) >= GunItem.getChargeDuration(itemstack = this.mob.m_21211_())) {
                this.mob.m_21253_();
                this.gunState = GunState.CHARGED;
                this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
                this.ammoCount = GunItem.getCurrentAmmoCount(this.mob.m_21120_(InteractionHand.MAIN_HAND));
                ((CrossbowAttackMob)this.mob).m_6136_(false);
            }
        } else if (this.gunState == GunState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.gunState = GunState.READY_TO_ATTACK;
            }
        } else if (this.gunState == GunState.READY_TO_ATTACK && flag) {
            InteractionHand interactionhand = ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof GunItem);
            ItemStack itemstack = this.mob.m_21120_(interactionhand);
            if (this.mob.m_21093_(is -> is.m_41720_() instanceof GunItem)) {
                GunItem.performShooting(this.mob.m_9236_(), this.mob, interactionhand, itemstack, 5.0f, 14 - this.mob.m_9236_().m_46791_().m_19028_() * 4);
            }
            ((CrossbowAttackMob)this.mob).m_5847_();
            --this.ammoCount;
            ItemStack itemstack1 = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof GunItem));
            if (this.ammoCount <= 0) {
                GunItem.setCharged(itemstack1, false);
                this.gunState = GunState.UNCHARGED;
            } else {
                this.gunState = GunState.CHARGED;
                this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
            }
        }
    }

    private boolean canRun() {
        return this.gunState == GunState.UNCHARGED;
    }

    static enum GunState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

