/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.pillagers_gun.event;

import com.scarasol.pillagers_gun.compat.guardvillagers.GuardUseGun;
import com.scarasol.pillagers_gun.compat.recruits.RecruitUseGun;
import com.scarasol.pillagers_gun.config.CommonConfig;
import com.scarasol.pillagers_gun.entity.goal.GunAttackGoal;
import com.scarasol.pillagers_gun.init.PillagersGunItems;
import com.scarasol.pillagers_gun.item.gun.GunItem;
import java.util.Random;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        Random random = new Random();
        if (entity == null) {
            return;
        }
        if (entity instanceof Pillager) {
            Pillager mob = (Pillager)entity;
            mob.f_21345_.m_25352_(2, new GunAttackGoal<Pillager>(mob, 1.0, 8.0f));
            if (mob.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42717_) && !event.loadedFromDisk() && random.nextDouble() <= (Double)CommonConfig.EQUIP_CHANCE.get()) {
                double totalWeights = (Double)CommonConfig.ASSAULT_CHANCE.get() + (Double)CommonConfig.PISTOL_CHANCE.get() + (Double)CommonConfig.SHOTGUN_CHANCE.get();
                double i = random.nextDouble() * totalWeights;
                ItemStack itemStack = i < (Double)CommonConfig.PISTOL_CHANCE.get() / totalWeights ? new ItemStack((ItemLike)PillagersGunItems.PISTOL.get()) : (i < ((Double)CommonConfig.PISTOL_CHANCE.get() + (Double)CommonConfig.ASSAULT_CHANCE.get()) / totalWeights ? new ItemStack((ItemLike)PillagersGunItems.ASSAULT_RIFLE.get()) : new ItemStack((ItemLike)PillagersGunItems.SHOTGUN.get()));
                GunItem.init(itemStack);
                itemStack.m_41764_(1);
                mob.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                mob.m_21409_(EquipmentSlot.MAINHAND, ((Double)CommonConfig.DROP_CHANCE.get()).floatValue());
            }
        }
        if (ModList.get().isLoaded("guardvillagers")) {
            GuardUseGun.makeGuardUseGun(entity);
        }
        if (ModList.get().isLoaded("recruits")) {
            RecruitUseGun.makeCrossBowmanUseGun(entity);
        }
    }
}

