/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.pillagers_gun.item.gun;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class GunItem
extends ProjectileWeaponItem
implements Vanishable {
    private static final float AMMO_POWER = 6.0f;
    private boolean startSoundPlayed = false;
    private final Predicate<ItemStack> AMMO = itemStack -> itemStack.m_150930_(this.getAmmo());

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public abstract SoundEvent getFireSound();

    public abstract SoundEvent getReloadSound();

    public static int getChargeDuration(ItemStack itemStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)itemStack);
        Item item = itemStack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.getMaxChargeDuration() - 5 * i;
        }
        return 0;
    }

    public UseAnim m_6164_(ItemStack p_40935_) {
        return UseAnim.CROSSBOW;
    }

    public Predicate<ItemStack> m_6442_() {
        return this.AMMO;
    }

    public Predicate<ItemStack> m_6437_() {
        return this.AMMO;
    }

    public abstract Item getAmmo();

    public abstract int getAmmoCount();

    public abstract int getMaxChargeDuration();

    public abstract int getCooldownTime();

    public abstract int getShotCount();

    public int m_8105_(ItemStack itemStack) {
        return GunItem.getChargeDuration(itemStack) + 3;
    }

    public boolean m_41463_(ItemStack itemStack) {
        return itemStack.m_150930_((Item)this);
    }

    private static float getShootingPower(ItemStack itemStack) {
        return 6.0f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (GunItem.isCharged(itemstack)) {
            GunItem.performShooting(level, (LivingEntity)player, interactionHand, itemstack, GunItem.getShootingPower(itemstack), 1.0f);
            player.m_36335_().m_41524_(itemstack.m_41720_(), this.getCooldownTime());
            int ammo = itemstack.m_41784_().m_128451_("ammo");
            if (ammo == 0) {
                GunItem.setCharged(itemstack, false);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!player.m_6298_(itemstack).m_41619_()) {
            if (!GunItem.isCharged(itemstack)) {
                this.startSoundPlayed = false;
                player.m_6672_(interactionHand);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int p_40913_) {
        if (!level.f_46443_) {
            float f = (float)(itemStack.m_41779_() - p_40913_) / (float)GunItem.getChargeDuration(itemStack);
            if (f < 0.1f) {
                this.startSoundPlayed = false;
            }
            if (f == 0.1f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), this.getReloadSound(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    private static void addChargedProjectile(ItemStack gun, ItemStack ammo, int ammoCount) {
        Item item = gun.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            CompoundTag compoundtag = gun.m_41784_();
            ListTag listtag = compoundtag.m_128425_("ChargedProjectiles", 9) ? compoundtag.m_128437_("ChargedProjectiles", 10) : new ListTag();
            if (ammo.m_150930_(Items.f_42412_)) {
                ammo = new ItemStack((ItemLike)gunItem.getAmmo());
            }
            CompoundTag compoundtag1 = new CompoundTag();
            ammo.m_41739_(compoundtag1);
            listtag.add((Object)compoundtag1);
            compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
            compoundtag.m_128405_("ammo", ammoCount);
        }
    }

    public static void init(ItemStack gun) {
        GunItem gunItem;
        int i;
        Item item = gun.m_41720_();
        if (item instanceof GunItem && (i = new Random().nextInt((gunItem = (GunItem)item).getAmmoCount() + 1)) != 0) {
            ItemStack itemstack = new ItemStack((ItemLike)gunItem.getAmmo());
            GunItem.addChargedProjectile(gun, itemstack, i);
            GunItem.setCharged(gun, true);
        }
    }

    public static int getCurrentAmmoCount(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null) {
            return compoundtag.m_128451_("ammo");
        }
        return 0;
    }

    private boolean loadProjectile(LivingEntity livingEntity, ItemStack gun, ItemStack ammo, boolean p_40866_, boolean p_40867_) {
        Item item;
        ItemStack itemstack;
        if (ammo.m_41619_()) {
            return false;
        }
        if (!p_40867_ && !p_40866_) {
            itemstack = ammo.m_41620_(1);
            if (ammo.m_41619_() && livingEntity instanceof Player) {
                ((Player)livingEntity).m_150109_().m_36057_(ammo);
            }
        } else {
            itemstack = ammo.m_41777_();
        }
        if ((item = gun.m_41720_()) instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            GunItem.addChargedProjectile(gun, itemstack, gunItem.getAmmoCount());
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean tryLoadProjectiles(LivingEntity livingEntity, ItemStack gun) {
        i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)gun);
        j = i == 0 ? 0 : 2;
        shotCount = this.getShotCount() + j;
        if (!(livingEntity instanceof Player)) ** GOTO lbl-1000
        player = (Player)livingEntity;
        if (player.m_150110_().f_35937_) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        flag = v0;
        itemstack = livingEntity.m_6298_(gun);
        itemstack1 = itemstack.m_41777_();
        for (k = 0; k < shotCount; ++k) {
            if (k > 0) {
                itemstack = itemstack1.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)this.getAmmo());
                itemstack1 = itemstack.m_41777_();
            }
            if (this.loadProjectile(livingEntity, gun, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int useTime) {
        int i = this.m_8105_(itemStack) - useTime;
        float f = this.getPowerForTime(i, itemStack);
        if (f >= 1.0f && !GunItem.isCharged(itemStack) && this.tryLoadProjectiles(livingEntity, itemStack)) {
            GunItem.setCharged(itemStack, true);
        } else if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(this.getReloadSound().m_11660_(), SoundSource.PLAYERS));
        }
    }

    private float getPowerForTime(int lastTime, ItemStack itemStack) {
        float f = (float)lastTime / (float)GunItem.getChargeDuration(itemStack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static void performShooting(Level level, LivingEntity livingEntity, InteractionHand interactionHand, ItemStack itemStack, float p_40892_, float p_40893_) {
        Item item = itemStack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            List<ItemStack> list = GunItem.getChargedProjectiles(itemStack);
            float[] afloat = GunItem.getShotPitches(livingEntity.m_217043_());
            for (int i = 0; i < list.size(); ++i) {
                boolean flag;
                ItemStack itemstack = list.get(i);
                boolean bl = flag = livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35937_;
                if (itemstack.m_41619_()) continue;
                if (i == 0) {
                    GunItem.shootProjectile(level, livingEntity, interactionHand, itemStack, itemstack, flag, p_40892_, p_40893_, 0.0f);
                    continue;
                }
                if (level.m_213780_().m_188500_() < 0.5) {
                    GunItem.shootProjectile(level, livingEntity, interactionHand, itemStack, itemstack, flag, p_40892_, p_40893_, new Random().nextFloat() * 5.0f);
                    continue;
                }
                GunItem.shootProjectile(level, livingEntity, interactionHand, itemStack, itemstack, flag, p_40892_, p_40893_, new Random().nextFloat() * -5.0f);
            }
            level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), gunItem.getFireSound(), SoundSource.PLAYERS, 0.6f, afloat[0]);
            GunItem.onGunShot(level, livingEntity, itemStack);
        }
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack itemStack) {
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("ChargedProjectiles", 9)) {
            ListTag listtag = compoundtag.m_128437_("ChargedProjectiles", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundtag1));
            }
        }
        return list;
    }

    private static float getRandomShotPitch(boolean p_150798_, RandomSource p_150799_) {
        float f = p_150798_ ? 0.63f : 0.43f;
        return 1.0f / (p_150799_.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static float[] getShotPitches(RandomSource p_40924_) {
        boolean flag = p_40924_.m_188499_();
        return new float[]{1.0f, GunItem.getRandomShotPitch(flag, p_40924_), GunItem.getRandomShotPitch(!flag, p_40924_)};
    }

    private static void onGunShot(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverPlayer, itemStack);
            }
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        }
        int ammo = itemStack.m_41784_().m_128451_("ammo");
        itemStack.m_41784_().m_128405_("ammo", --ammo);
        if (ammo == 0) {
            GunItem.clearChargedProjectiles(itemStack);
        }
    }

    private static void clearChargedProjectiles(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128437_("ChargedProjectiles", 9);
            listtag.clear();
            compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
        }
    }

    private static void shootProjectile(Level level, LivingEntity livingEntity, InteractionHand interactionHand, ItemStack gun, ItemStack ammo, boolean p_40901_, float p_40902_, float p_40903_, float p_40904_) {
        if (!level.f_46443_) {
            AbstractArrow projectile = GunItem.getAmmo(level, livingEntity, gun, ammo);
            if (p_40901_ || p_40904_ != 0.0f) {
                projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            Vec3 vec31 = livingEntity.m_20289_(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(p_40904_ * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
            Vec3 vec3 = livingEntity.m_20252_(1.0f);
            Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
            projectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), p_40902_, p_40903_);
            gun.m_41622_(1, livingEntity, p_40858_ -> p_40858_.m_21190_(interactionHand));
            level.m_7967_((Entity)projectile);
        }
    }

    private static AbstractArrow getAmmo(Level level, LivingEntity livingEntity, ItemStack gun, ItemStack ammo) {
        Item item = gun.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            ArrowItem arrowItem = (ArrowItem)(ammo.m_41720_() instanceof ArrowItem ? ammo.m_41720_() : gunItem.getAmmo());
            AbstractArrow abstractarrow = arrowItem.m_6394_(level, ammo, livingEntity);
            abstractarrow.m_36793_(true);
            int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)gun);
            if (i > 0) {
                abstractarrow.m_36767_((byte)i);
            }
            return abstractarrow;
        }
        return null;
    }

    public static boolean isCharged(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && compoundtag.m_128471_("Charged");
    }

    public static void setCharged(ItemStack itemStack, boolean charged) {
        CompoundTag compoundtag = itemStack.m_41784_();
        compoundtag.m_128379_("Charged", charged);
    }

    public int m_6615_() {
        return 8;
    }
}

