/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.gen;

import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.Orientation;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Bridges {
    public static void generateBridges(LostCityTerrainFeature feature, BuildingInfo info) {
        if (info.getHighwayXLevel() == 0 || info.getHighwayZLevel() == 0) {
            return;
        }
        BuildingPart bt = info.hasXBridge(info.provider);
        if (bt != null) {
            Bridges.generateBridge(feature, info, bt, Orientation.X);
        } else {
            bt = info.hasZBridge(info.provider);
            if (bt != null) {
                Bridges.generateBridge(feature, info, bt, Orientation.Z);
            }
        }
    }

    private static void generateBridge(LostCityTerrainFeature feature, BuildingInfo info, BuildingPart bt, Orientation orientation) {
        block18: {
            CompiledPalette compiledPalette = feature.computePalette(info, bt);
            ChunkDriver driver = feature.driver;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    driver.current(x, info.profile.GROUNDLEVEL + 1, z);
                    for (int l = 0; l < bt.getSliceCount(); ++l) {
                        Character c = orientation == Orientation.X ? bt.getPaletteChar(x, l, z) : bt.getPaletteChar(z, l, x);
                        BlockState b = compiledPalette.get(c.charValue());
                        Palette.Info inf = compiledPalette.getInfo(c);
                        if (inf != null && inf.isTorch()) {
                            if (info.profile.GENERATE_LIGHTING) {
                                info.addTorchTodo(driver.getCurrentCopy());
                            } else {
                                b = Blocks.f_50016_.m_49966_();
                            }
                        }
                        driver.add(b);
                    }
                }
            }
            Character support = bt.getMetaChar("support");
            if (!info.profile.BRIDGE_SUPPORTS || support == null) break block18;
            BlockState sup = compiledPalette.get(support.charValue());
            BuildingInfo minDir = orientation.getMinDir().get(info);
            BuildingInfo maxDir = orientation.getMaxDir().get(info);
            if (minDir.hasBridge(info.provider, orientation) != null && maxDir.hasBridge(info.provider, orientation) != null) {
                for (int y = info.waterLevel - 10; y <= info.groundLevel; ++y) {
                    driver.current(7, y, 7).block(sup);
                    driver.current(7, y, 8).block(sup);
                    driver.current(8, y, 7).block(sup);
                    driver.current(8, y, 8).block(sup);
                }
            }
            if (minDir.hasBridge(info.provider, orientation) == null) {
                if (orientation == Orientation.X) {
                    int x = 0;
                    driver.current(x, info.profile.GROUNDLEVEL, 6);
                    for (int z = 6; z <= 9; ++z) {
                        driver.block(sup).incZ();
                    }
                } else {
                    int z = 0;
                    driver.current(6, info.profile.GROUNDLEVEL, z);
                    for (int x = 6; x <= 9; ++x) {
                        driver.block(sup).incX();
                    }
                }
            }
            if (maxDir.hasBridge(info.provider, orientation) == null) {
                if (orientation == Orientation.X) {
                    int x = 15;
                    driver.current(x, info.profile.GROUNDLEVEL, 6);
                    for (int z = 6; z <= 9; ++z) {
                        driver.block(sup).incZ();
                    }
                } else {
                    int z = 15;
                    driver.current(6, info.profile.GROUNDLEVEL, z);
                    for (int x = 6; x <= 9; ++x) {
                        driver.block(sup).incX();
                    }
                }
            }
        }
    }
}

