/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class LinkableBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    protected List<LinkedBlock> linkedBlocks = new ArrayList<LinkedBlock>();
    private ListTag nbtTagStorage = null;

    protected LinkableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.m_58898_() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("linkedBlocks")) {
            if (!this.m_58898_()) {
                this.nbtTagStorage = tag.m_128437_("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.m_128437_("linkedBlocks", 10));
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.linkedBlocks.isEmpty()) {
            ListTag tagList = new ListTag();
            for (LinkedBlock block : this.linkedBlocks) {
                CompoundTag toAppend = new CompoundTag();
                if (block != null) {
                    toAppend.m_128359_("blockName", block.getBlockName());
                    toAppend.m_128405_("blockX", block.getX());
                    toAppend.m_128405_("blockY", block.getY());
                    toAppend.m_128405_("blockZ", block.getZ());
                }
                tagList.add((Object)toAppend);
            }
            tag.m_128365_("linkedBlocks", (Tag)tagList);
        }
    }

    public void m_7651_() {
        for (LinkedBlock block : this.linkedBlocks) {
            if (!this.f_58857_.m_46749_(block.getPos())) continue;
            LinkableBlockEntity.unlink(block.asBlockEntity(this.f_58857_), this);
        }
        super.m_7651_();
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        this.propagate(new ILinkedAction.OptionChanged<T>(option), this);
        super.onOptionChanged(option);
    }

    private void readLinkedBlocks(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            String name = list.m_128728_(i).m_128461_("blockName");
            int x = list.m_128728_(i).m_128451_("blockX");
            int y = list.m_128728_(i).m_128451_("blockY");
            int z = list.m_128728_(i).m_128451_("blockZ");
            LinkedBlock block = new LinkedBlock(name, new BlockPos(x, y, z));
            if (!this.m_58898_() || !this.f_58857_.m_46749_(block.getPos()) || !block.validate(this.f_58857_) || this.linkedBlocks.contains(block)) continue;
            LinkableBlockEntity.link(this, block.asBlockEntity(this.f_58857_));
        }
    }

    public static void link(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        if (LinkableBlockEntity.isLinkedWith(blockEntity1, blockEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(blockEntity1);
        LinkedBlock block2 = new LinkedBlock(blockEntity2);
        if (!blockEntity1.linkedBlocks.contains(block2)) {
            blockEntity1.linkedBlocks.add(block2);
            blockEntity1.m_6596_();
        }
        if (!blockEntity2.linkedBlocks.contains(block1)) {
            blockEntity2.linkedBlocks.add(block1);
            blockEntity2.m_6596_();
        }
    }

    public static void unlink(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        if (blockEntity1 == null || blockEntity2 == null) {
            return;
        }
        LinkedBlock block = new LinkedBlock(blockEntity2);
        if (blockEntity1.linkedBlocks.contains(block)) {
            blockEntity1.linkedBlocks.remove(block);
            blockEntity1.m_6596_();
        }
    }

    public static boolean isLinkedWith(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        return blockEntity1.linkedBlocks.contains(new LinkedBlock(blockEntity2)) && blockEntity2.linkedBlocks.contains(new LinkedBlock(blockEntity1));
    }

    public void propagate(ILinkedAction action, LinkableBlockEntity excludedBE) {
        ArrayList<LinkableBlockEntity> list = new ArrayList<LinkableBlockEntity>();
        list.add(excludedBE);
        this.propagate(action, list);
    }

    public void propagate(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
        Iterator<LinkedBlock> linkedBlockIterator = this.linkedBlocks.iterator();
        while (linkedBlockIterator.hasNext()) {
            LinkedBlock block = linkedBlockIterator.next();
            if (!this.f_58857_.m_46749_(block.getPos()) || excludedBEs.contains(block.asBlockEntity(this.f_58857_))) continue;
            if (block.validate(this.f_58857_)) {
                BlockState state = this.f_58857_.m_8055_(block.getPos());
                block.asBlockEntity(this.f_58857_).onLinkedBlockAction(action, excludedBEs);
                this.f_58857_.m_7260_(block.getPos(), state, state, 3);
                continue;
            }
            linkedBlockIterator.remove();
        }
    }

    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
    }
}

