/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.stream.Stream;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class TrophySystemBlock
extends DisguisableBlock {
    private static final VoxelShape SHAPE = Stream.of(Shapes.m_83048_((double)0.3125, (double)0.625, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), Shapes.m_83048_((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625), Shapes.m_83048_((double)0.4375, (double)0.4375, (double)0.625, (double)0.5625, (double)0.5625, (double)0.875), Shapes.m_83048_((double)0.375, (double)0.5, (double)0.8125, (double)0.625, (double)0.75, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.5, (double)0.375, (double)0.1875, (double)0.75, (double)0.625), Shapes.m_83048_((double)0.625, (double)0.4375, (double)0.4375, (double)0.875, (double)0.5625, (double)0.5625), Shapes.m_83048_((double)0.125, (double)0.4375, (double)0.4375, (double)0.375, (double)0.5625, (double)0.5625), Shapes.m_83048_((double)0.8125, (double)0.5, (double)0.375, (double)1.0, (double)0.75, (double)0.625), Shapes.m_83048_((double)0.4375, (double)0.4375, (double)0.125, (double)0.5625, (double)0.5625, (double)0.375), Shapes.m_83048_((double)0.375, (double)0.5, (double)0.0, (double)0.625, (double)0.75, (double)0.1875), Shapes.m_83048_((double)0.4375, (double)0.1875, (double)0.4375, (double)0.5625, (double)0.375, (double)0.5625)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83144_());

    public TrophySystemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return BlockUtils.isSideSolid(level, pos.m_7495_(), Direction.UP);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TrophySystemBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrophySystemBlockEntity && (be = (TrophySystemBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!level.f_46443_) {
                if (be.isDisabled()) {
                    player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)be, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return SHAPE;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof TrophySystemBlockEntity) {
            TrophySystemBlockEntity inv = (TrophySystemBlockEntity)blockEntity;
            inv.getInventory().clear();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof TrophySystemBlockEntity) {
            TrophySystemBlockEntity be = (TrophySystemBlockEntity)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)be.getLensContainer());
            be.dropAllModules();
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrophySystemBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TrophySystemBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

