/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class ExplosiveBlock
extends OwnableBlock
implements IExplosive {
    protected ExplosiveBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return (Boolean)ConfigHandler.SERVER.ableToBreakMines.get() == false ? -1.0f : super.m_5880_(state, player, level, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_150930_((Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get())) {
            return InteractionResult.SUCCESS;
        }
        if (this.isActive(level, pos) && this.isDefusable() && player.m_21120_(hand).m_41720_() == SCContent.WIRE_CUTTERS.get()) {
            if (this.defuseMine(level, pos)) {
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.isActive(level, pos) && heldItem.m_150930_(Items.f_42409_) && this.activateMine(level, pos)) {
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            level.m_5594_(null, pos, SoundEvents.f_12524_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.explodesWhenInteractedWith() && this.isActive(level, pos)) {
            BlockEntity be = level.m_7702_(pos);
            Option<?>[] optionArray = level.m_7702_(pos);
            if (optionArray instanceof ICustomizable) {
                ICustomizable mine = (ICustomizable)optionArray;
                for (Option<Object> option : mine.customOptions()) {
                    Option.TargetingModeOption targetingMode;
                    if (option instanceof Option.EntityDataWrappedOption) {
                        Option.EntityDataWrappedOption wrapped = (Option.EntityDataWrappedOption)option;
                        option = wrapped.getWrapped();
                    }
                    if (option instanceof Option.TargetingModeOption && !((TargetingMode)((Object)(targetingMode = (Option.TargetingModeOption)option).get())).allowsPlayers()) {
                        return InteractionResult.PASS;
                    }
                    if (!(option instanceof Option.IgnoreOwnerOption)) continue;
                    Option.IgnoreOwnerOption ignoreOwner = (Option.IgnoreOwnerOption)option;
                    if (!((IOwnable)be).isOwnedBy((Entity)player) || !((Boolean)ignoreOwner.get()).booleanValue()) continue;
                    return InteractionResult.PASS;
                }
            }
            this.explode(level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean explodesWhenInteractedWith() {
        return true;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }
}

