/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityAccess;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class}, priority=1100)
public abstract class ChunkMapMixin {
    @Unique
    private static final Map<ServerPlayer, SectionPos> OLD_SECTION_POSITIONS = new HashMap<ServerPlayer, SectionPos>();
    @Shadow
    @Final
    private PlayerMap f_140149_;
    @Shadow
    int f_140126_;

    @Shadow
    protected abstract void m_183754_(ServerPlayer var1, ChunkPos var2, MutableObject<ClientboundLevelChunkWithLightPacket> var3, boolean var4, boolean var5);

    @Inject(method={"setViewDistance"}, at={@At(value="HEAD")})
    private void securitycraft$setCameraSectionPos(int viewDistance, CallbackInfo ci) {
        for (ServerPlayer player : this.f_140149_.m_183926_(0L)) {
            if (!PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) continue;
            OLD_SECTION_POSITIONS.put(player, player.m_8965_());
            player.m_9119_(SectionPos.m_235861_((EntityAccess)player.m_8954_()));
        }
    }

    @Inject(method={"setViewDistance"}, at={@At(value="TAIL")})
    private void securitycraft$restorePreviousSectionPos(int viewDistance, CallbackInfo ci) {
        for (Map.Entry<ServerPlayer, SectionPos> entry : OLD_SECTION_POSITIONS.entrySet()) {
            entry.getKey().m_9119_(entry.getValue());
        }
        OLD_SECTION_POSITIONS.clear();
    }

    @Redirect(method={"getPlayers"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getLastSectionPos()Lnet/minecraft/core/SectionPos;"))
    private SectionPos securitycraft$getCameraSectionPos(ServerPlayer player) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            return SectionPos.m_235861_((EntityAccess)player.m_8954_());
        }
        return player.m_8965_();
    }

    @Inject(method={"move"}, at={@At(value="TAIL")})
    private void securitycraft$trackCameraLoadedChunks(ServerPlayer player, CallbackInfo callback) {
        Entity entity = player.m_8954_();
        if (entity instanceof SecurityCamera) {
            SecurityCamera camera = (SecurityCamera)entity;
            if (!camera.hasSentChunks()) {
                pos = SectionPos.m_235861_((EntityAccess)camera);
                for (int i = pos.m_123170_() - this.f_140126_; i <= pos.m_123170_() + this.f_140126_; ++i) {
                    for (int j = pos.m_123222_() - this.f_140126_; j <= pos.m_123222_() + this.f_140126_; ++j) {
                        this.m_183754_(player, new ChunkPos(i, j), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                    }
                }
                camera.setHasSentChunks(true);
            }
        } else if (SecurityCamera.hasRecentlyDismounted((Player)player)) {
            pos = player.m_8965_();
            for (int i = pos.m_123170_() - this.f_140126_; i <= pos.m_123170_() + this.f_140126_; ++i) {
                for (int j = pos.m_123222_() - this.f_140126_; j <= pos.m_123222_() + this.f_140126_; ++j) {
                    this.m_183754_(player, new ChunkPos(i, j), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                }
            }
        }
    }
}

