/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.util.ColorUtils;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.block.render.SpriteShifter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public class CRSpriteShifts {
    public static final CTSpriteShiftEntry FUEL_TANK = CRSpriteShifts.getCT((CTType)AllCTTypes.RECTANGLE, "fuel_tank");
    public static final CTSpriteShiftEntry FUEL_TANK_TOP = CRSpriteShifts.getCT((CTType)AllCTTypes.RECTANGLE, "fuel_tank_top");
    public static final CTSpriteShiftEntry FUEL_TANK_INNER = CRSpriteShifts.getCT((CTType)AllCTTypes.RECTANGLE, "fuel_tank_inner");
    public static final Map<@Nullable DyeColor, CTSpriteShiftEntry> SLASHED_LOCOMETAL = new HashMap<DyeColor, CTSpriteShiftEntry>(17, 2.0f);
    public static final Map<@Nullable DyeColor, CTSpriteShiftEntry> RIVETED_LOCOMETAL = new HashMap<DyeColor, CTSpriteShiftEntry>(17, 2.0f);
    public static final Map<@Nullable DyeColor, CTSpriteShiftEntry> BRASS_WRAPPED_LOCOMETAL = new HashMap<DyeColor, CTSpriteShiftEntry>(17, 2.0f);
    public static final Map<@Nullable DyeColor, CTSpriteShiftEntry> COPPER_WRAPPED_LOCOMETAL = new HashMap<DyeColor, CTSpriteShiftEntry>(17, 2.0f);
    public static final Map<@Nullable DyeColor, CTSpriteShiftEntry> IRON_WRAPPED_LOCOMETAL = new HashMap<DyeColor, CTSpriteShiftEntry>(17, 2.0f);
    public static final Map<@Nullable DyeColor, CTSpriteShiftEntry> BOILER_SIDE = new HashMap<DyeColor, CTSpriteShiftEntry>(17, 2.0f);
    public static final Map<@Nullable DyeColor, CTSpriteShiftEntry> BRASS_WRAPPED_BOILER_SIDE = new HashMap<DyeColor, CTSpriteShiftEntry>(17, 2.0f);
    public static final Map<@Nullable DyeColor, CTSpriteShiftEntry> COPPER_WRAPPED_BOILER_SIDE = new HashMap<DyeColor, CTSpriteShiftEntry>(17, 2.0f);
    public static final Map<@Nullable DyeColor, CTSpriteShiftEntry> IRON_WRAPPED_BOILER_SIDE = new HashMap<DyeColor, CTSpriteShiftEntry>(17, 2.0f);

    private static void initLocometal(@Nullable DyeColor color) {
        SLASHED_LOCOMETAL.put(color, CRSpriteShifts.locometal(color, "slashed"));
        RIVETED_LOCOMETAL.put(color, CRSpriteShifts.locometal(color, "riveted"));
        BRASS_WRAPPED_LOCOMETAL.put(color, CRSpriteShifts.locometal(color, "wrapped_slashed"));
        COPPER_WRAPPED_LOCOMETAL.put(color, CRSpriteShifts.locometal(color, "copper_wrapped_slashed"));
        IRON_WRAPPED_LOCOMETAL.put(color, CRSpriteShifts.locometal(color, "iron_wrapped_slashed"));
        BOILER_SIDE.put(color, CRSpriteShifts.locometalBoiler(color, "boiler_side"));
        BRASS_WRAPPED_BOILER_SIDE.put(color, CRSpriteShifts.locometalBoiler(color, "wrapped_boiler_side"));
        COPPER_WRAPPED_BOILER_SIDE.put(color, CRSpriteShifts.locometalBoiler(color, "copper_wrapped_boiler_side"));
        IRON_WRAPPED_BOILER_SIDE.put(color, CRSpriteShifts.locometalBoiler(color, "iron_wrapped_boiler_side"));
    }

    private static CTSpriteShiftEntry locometal(@Nullable DyeColor color, String name) {
        String colorName = color == null ? "netherite" : color.name().toLowerCase(Locale.ROOT);
        return CRSpriteShifts.omni("palettes/" + colorName + "/" + name);
    }

    private static CTSpriteShiftEntry locometalBoiler(@Nullable DyeColor color, String name) {
        String colorName = color == null ? "netherite" : color.name().toLowerCase(Locale.ROOT);
        return CRSpriteShifts.horizontalKryppers("palettes/" + colorName + "/" + name);
    }

    private static CTSpriteShiftEntry omni(String name) {
        return CRSpriteShifts.getCT((CTType)AllCTTypes.OMNIDIRECTIONAL, name);
    }

    private static CTSpriteShiftEntry horizontal(String name) {
        return CRSpriteShifts.getCT((CTType)AllCTTypes.HORIZONTAL, name);
    }

    private static CTSpriteShiftEntry horizontalKryppers(String name) {
        return CRSpriteShifts.getCT((CTType)AllCTTypes.HORIZONTAL_KRYPPERS, name);
    }

    private static CTSpriteShiftEntry vertical(String name) {
        return CRSpriteShifts.getCT((CTType)AllCTTypes.VERTICAL, name);
    }

    private static SpriteShiftEntry get(String originalLocation, String targetLocation) {
        return SpriteShifter.get((ResourceLocation)Railways.asResource(originalLocation), (ResourceLocation)Railways.asResource(targetLocation));
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName, String connectedTextureName) {
        return CTSpriteShifter.getCT((CTType)type, (ResourceLocation)Railways.asResource("block/" + blockTextureName), (ResourceLocation)Railways.asResource("block/" + connectedTextureName + "_connected"));
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName) {
        return CRSpriteShifts.getCT(type, blockTextureName, blockTextureName);
    }

    public static void register() {
    }

    static {
        CRSpriteShifts.initLocometal(null);
        for (DyeColor color : ColorUtils.ORDERED_DYE_COLORS) {
            CRSpriteShifts.initLocometal(color);
        }
    }
}

