/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.recipeserializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public abstract class UShapedRecipeSerializer<T extends ShapedRecipe>
implements RecipeSerializer<T> {
    public static NonNullList<Ingredient> dissolvePattern(String[] pattern, Map<String, Ingredient> keys, int width, int height) {
        return ShapedRecipe.m_44202_((String[])pattern, keys, (int)width, (int)height);
    }

    public static String[] shrink(String ... shrink) {
        return ShapedRecipe.m_44186_((String[])shrink);
    }

    public static String[] patternFromJson(JsonArray json) {
        return ShapedRecipe.m_44196_((JsonArray)json);
    }

    public static Map<String, Ingredient> keyFromJson(JsonObject json) {
        return ShapedRecipe.m_44210_((JsonObject)json);
    }

    public static ItemStack itemStackFromJson(JsonObject json) {
        return ShapedRecipe.m_151274_((JsonObject)json);
    }

    public static Item itemFromJson(JsonObject json) {
        return ShapedRecipe.m_151278_((JsonObject)json);
    }

    public T fromJson(ResourceLocation location, JsonObject json) {
        String[] pattern = UShapedRecipeSerializer.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern"));
        int recipeWidth = pattern[0].length();
        int recipeHeight = pattern.length;
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
        NonNullList<Ingredient> ingredients = UShapedRecipeSerializer.dissolvePattern(pattern, UShapedRecipeSerializer.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key")), recipeWidth, recipeHeight);
        ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        boolean showNotification = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
        return this.createRecipe(location, group, category, recipeWidth, recipeHeight, ingredients, output, showNotification);
    }

    public T fromNetwork(ResourceLocation location, FriendlyByteBuf buffer) {
        int recipeWidth = buffer.m_130242_();
        int recipeHeight = buffer.m_130242_();
        String group = buffer.m_130277_();
        CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
        NonNullList ingredients = NonNullList.m_122780_((int)(recipeWidth * recipeHeight), (Object)Ingredient.f_43901_);
        for (int k = 0; k < ingredients.size(); ++k) {
            ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        ItemStack output = buffer.m_130267_();
        boolean showNotification = buffer.readBoolean();
        return this.createRecipe(location, group, category, recipeWidth, recipeHeight, (NonNullList<Ingredient>)ingredients, output, showNotification);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130130_(((ShapedRecipe)recipe).f_44146_);
        buffer.m_130130_(((ShapedRecipe)recipe).f_44147_);
        buffer.m_130070_(((ShapedRecipe)recipe).f_44151_);
        buffer.m_130068_((Enum)((ShapedRecipe)recipe).f_244483_);
        for (Ingredient ingredient : ((ShapedRecipe)recipe).f_44148_) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130055_(((ShapedRecipe)recipe).f_44149_);
        buffer.writeBoolean(((ShapedRecipe)recipe).f_271538_);
    }

    protected abstract T createRecipe(ResourceLocation var1, String var2, CraftingBookCategory var3, int var4, int var5, NonNullList<Ingredient> var6, ItemStack var7, boolean var8);

    protected record ShapedRecipeValues(int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result, ResourceLocation id, String group, CraftingBookCategory category, boolean showNotification) {
        public ShapedRecipeValues(ShapedRecipe shapedRecipe) {
            this(shapedRecipe.f_44146_, shapedRecipe.f_44147_, (NonNullList<Ingredient>)shapedRecipe.f_44148_, shapedRecipe.f_44149_, shapedRecipe.f_44150_, shapedRecipe.f_44151_, shapedRecipe.f_244483_, shapedRecipe.f_271538_);
        }
    }
}

