/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.CrosshairVisibility;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;

public enum Perspective {
    FIRST_PERSON(CameraType.FIRST_PERSON, CrosshairVisibility.ALWAYS),
    THIRD_PERSON_BACK(CameraType.THIRD_PERSON_BACK, CrosshairVisibility.NEVER),
    THIRD_PERSON_FRONT(CameraType.THIRD_PERSON_FRONT, CrosshairVisibility.NEVER),
    SHOULDER_SURFING(CameraType.THIRD_PERSON_BACK, CrosshairVisibility.ALWAYS);

    private final CameraType cameraType;
    private final CrosshairVisibility defaultCrosshairVisibility;

    private Perspective(CameraType cameraType, CrosshairVisibility defaultCrosshairVisibility) {
        this.cameraType = cameraType;
        this.defaultCrosshairVisibility = defaultCrosshairVisibility;
    }

    public CameraType getCameraType() {
        return this.cameraType;
    }

    public CrosshairVisibility getDefaultCrosshairVisibility() {
        return this.defaultCrosshairVisibility;
    }

    public Perspective next(boolean replaceDefaultPerspective, boolean skipThirdPersonFront) {
        Perspective next = Perspective.values()[(this.ordinal() + 1) % Perspective.values().length];
        if (replaceDefaultPerspective) {
            if (this == FIRST_PERSON) {
                next = SHOULDER_SURFING;
            } else if (this == SHOULDER_SURFING) {
                next = THIRD_PERSON_FRONT;
            } else if (this == THIRD_PERSON_FRONT) {
                next = FIRST_PERSON;
            }
        }
        if (skipThirdPersonFront && next == THIRD_PERSON_FRONT) {
            return next.next(replaceDefaultPerspective, true);
        }
        return next;
    }

    public static Perspective of(CameraType cameraType, boolean shoulderSurfing) {
        return switch (cameraType) {
            default -> throw new IncompatibleClassChangeError();
            case CameraType.FIRST_PERSON -> FIRST_PERSON;
            case CameraType.THIRD_PERSON_BACK -> {
                if (shoulderSurfing) {
                    yield SHOULDER_SURFING;
                }
                yield THIRD_PERSON_BACK;
            }
            case CameraType.THIRD_PERSON_FRONT -> THIRD_PERSON_FRONT;
        };
    }

    public static Perspective current() {
        return Perspective.of(Minecraft.m_91087_().f_91066_.m_92176_(), ShoulderSurfing.getInstance().isShoulderSurfing());
    }
}

