/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.mixins;

import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.mixins.GameRendererAccessor;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer
implements GameRendererAccessor {
    @Redirect(method={"pick"}, at=@At(value="INVOKE", target="net/minecraft/world/entity/projectile/ProjectileUtil.getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"))
    private EntityHitResult getEntityHitResult(Entity shooter, Vec3 startPos, Vec3 endPos, AABB boundingBox, Predicate<Entity> filter, double interactionRangeSq) {
        ShoulderSurfingImpl instance = ShoulderSurfingImpl.getInstance();
        if (instance.isShoulderSurfing()) {
            PickContext pickContext = new PickContext.Builder(this.getMainCamera()).withEntity(shooter).build();
            double interactionRange = Math.sqrt(interactionRangeSq);
            float partialTick = Minecraft.m_91087_().m_91296_();
            return instance.getObjectPicker().pickEntities(pickContext, interactionRange, partialTick);
        }
        return ProjectileUtil.m_37287_((Entity)shooter, (Vec3)startPos, (Vec3)endPos, (AABB)boundingBox, filter, (double)interactionRangeSq);
    }
}

