/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.extragore;

import com.eruannie_9.extragore.util.BloodParticleVariant;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfiguration {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue ONLY_PLAYER;
    public static final ForgeConfigSpec.BooleanValue ONLY_MOBS;
    public static final ForgeConfigSpec.BooleanValue BOTH;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLACKLISTED_ENTITY_IDS;
    public static final ForgeConfigSpec.EnumValue<BloodParticleVariant> BLOOD_PARTICLE_VARIANT;
    public static final ForgeConfigSpec.ConfigValue<Double> SMALL_SCALE;
    public static final ForgeConfigSpec.ConfigValue<Double> NORMAL_SCALE;
    public static final ForgeConfigSpec.ConfigValue<Double> LARGE_SCALE;
    public static final ForgeConfigSpec.ConfigValue<Double> SMALL_SPREAD;
    public static final ForgeConfigSpec.ConfigValue<Double> NORMAL_SPREAD;
    public static final ForgeConfigSpec.ConfigValue<Double> LARGE_SPREAD;
    public static final ForgeConfigSpec.ConfigValue<Integer> SMALL_COUNT;
    public static final ForgeConfigSpec.ConfigValue<Integer> NORMAL_COUNT;
    public static final ForgeConfigSpec.ConfigValue<Integer> LARGE_COUNT;
    public static final ForgeConfigSpec.ConfigValue<Integer> MIN_AGE;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_AGE;
    public static final ForgeConfigSpec.ConfigValue<Double> VIBRATION;
    public static final ForgeConfigSpec.ConfigValue<Double> UPWARD_MOTION;

    public static void registerConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Functionality Handler");
        builder.comment("Enable blood particle effect for players only.");
        ONLY_PLAYER = builder.define("Only_Player", false);
        builder.comment("Enable blood particle effect for mobs only.");
        ONLY_MOBS = builder.define("Only_Mobs", false);
        builder.comment("Enable blood particle effect for both players and mobs, overriding other settings.");
        BOTH = builder.define("Both", true);
        builder.comment("Entity list which will be blacklisted from getting blood particle effect.");
        BLACKLISTED_ENTITY_IDS = builder.defineList("Blacklisted_Entity", Arrays.asList("minecraft:ender_dragon", "minecraft:wither"), o -> o instanceof String);
        builder.pop();
        builder.push("Blood Particle Configuration");
        builder.comment("Max size value of the particle when hitting small entities.");
        SMALL_SCALE = builder.define("Small_Scale", (Object)1.1);
        builder.comment("Max size value of the particle when hitting normal entities.");
        NORMAL_SCALE = builder.define("Normal_Scale", (Object)1.8);
        builder.comment("Max size value of the particle when hitting large entities.");
        LARGE_SCALE = builder.define("Large_Scale", (Object)2.4);
        builder.comment("Max particle count at 0% health of a small entity.\nThis value scales with the percentage of the entity's health, which makes the minimum count as small as 1.");
        SMALL_COUNT = builder.define("Small_Count", (Object)30);
        builder.comment("Max particle count at 0% health of a normal entity.");
        NORMAL_COUNT = builder.define("Normal_Count", (Object)50);
        builder.comment("Max particle count at 0% health of a large entity.");
        LARGE_COUNT = builder.define("Large_Count", (Object)70);
        builder.comment("Spread in x and z direction for a small entity.\nSpread indicates the movement of particles in all direction from the entity.");
        SMALL_SPREAD = builder.define("Small_Spread", (Object)0.15);
        builder.comment("Spread in x and z direction for a normal entity.");
        NORMAL_SPREAD = builder.define("Normal_Spread", (Object)0.5);
        builder.comment("Spread in x and z direction for a large entity.");
        LARGE_SPREAD = builder.define("Large_Spread", (Object)0.7);
        builder.comment("This value defines vibration of the particle when stuck under or on the sides of a block.");
        VIBRATION = builder.define("On_Wall_Vibration", (Object)0.1);
        builder.comment("Min tick value for the life span of the particle.");
        MIN_AGE = builder.define("Min_Age", (Object)300);
        builder.comment("Max tick value for the life span of the particle.");
        MAX_AGE = builder.define("Max_Age", (Object)600);
        builder.comment("The y value of the particle movement.\nThis value can make the particle go higher or lower when spawn.");
        UPWARD_MOTION = builder.define("Upward_Motion", (Object)0.2);
        builder.pop();
        builder.push("Particle Variant");
        builder.comment("WARNING: Gore particle is still work in progress, but you can check it out and judge for yourself!");
        BLOOD_PARTICLE_VARIANT = builder.defineEnum("Blood_Particle_Variant", (Enum)BloodParticleVariant.SQUARE);
        builder.pop();
        SPEC = builder.build();
    }
}

