/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.extragore.events;

import com.eruannie_9.extragore.ModConfiguration;
import com.eruannie_9.extragore.ParticleConfiguration;
import com.eruannie_9.extragore.packet.BloodDataPacket;
import com.eruannie_9.extragore.packet.PacketHandler;
import com.eruannie_9.extragore.util.EntityConfig;
import com.eruannie_9.extragore.util.EntityUtil;
import com.eruannie_9.extragore.util.ParticleVariant;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityHurtEvent {
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || entity.m_9236_().f_46443_ || entity.m_6060_() || entity.m_20069_() && EntityHurtEvent.entityTakesWaterDamage(entity)) {
            return;
        }
        List blacklistedEntities = (List)ModConfiguration.BLACKLISTED_ENTITY_IDS.get();
        if (blacklistedEntities.contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString())) {
            return;
        }
        float damage = event.getAmount();
        ServerLevel serverLevel = (ServerLevel)entity.m_9236_();
        Color color = ParticleConfiguration.getColorForEntity(entity);
        EntityUtil.CollisionMode collisionMode = ParticleConfiguration.getControlModeForEntity(entity);
        EntityUtil.WeightMode weightMode = ParticleConfiguration.getWeightModeForEntity(entity);
        EntityUtil.StateMode stateMode = ParticleConfiguration.getStateModeForEntity(entity);
        int particleVariant = "V1".equals(ParticleVariant.getParticleVariant()) ? 1 : 2;
        int rgbColor = color.getRGB();
        EntityUtil.SizeInfo sizeInfo = EntityUtil.getSizeInfo((Entity)entity);
        EntityConfig config = EntityHurtEvent.getDynamicEntityConfig(sizeInfo, entity, damage);
        double entityX = entity.m_20185_();
        double entityY = entity.m_20186_();
        double entityZ = entity.m_20189_();
        double entityWidth = entity.m_20205_();
        double entityHeight = (double)entity.m_20206_() * 0.8;
        for (int i = 0; i < config.maxCount; ++i) {
            double speedFactor = 0.1 + Math.random() * 0.12;
            double dx = entity.m_217043_().m_188583_() * (double)config.spread * speedFactor;
            double dy = entity.m_217043_().m_188583_() * (double)config.spread * speedFactor + (double)config.ySpeed;
            double dz = entity.m_217043_().m_188583_() * (double)config.spread * speedFactor;
            EntityUtil.CollisionMode finalCollisionMode = collisionMode;
            if (collisionMode == EntityUtil.CollisionMode.MAGIC && Math.random() < 0.3) {
                finalCollisionMode = EntityUtil.CollisionMode.NONE;
            }
            EntityHurtEvent.spawnParticle(serverLevel, entityX, entityY, entityZ, entityWidth, entityHeight, dx, dy, dz, rgbColor, config.maxScale, particleVariant, finalCollisionMode, weightMode, stateMode);
        }
    }

    private static void spawnParticle(ServerLevel serverLevel, double x, double y, double z, double width, double height, double dx, double dy, double dz, int color, float scale, int variant, EntityUtil.CollisionMode collisionMode, EntityUtil.WeightMode weightMode, EntityUtil.StateMode stateMode) {
        double offsetX = (Math.random() - 0.5) * width;
        double offsetY = Math.random() * height;
        double offsetZ = (Math.random() - 0.5) * width;
        double particleX = x + offsetX;
        double particleY = y + offsetY;
        double particleZ = z + offsetZ;
        float finalScale = collisionMode == EntityUtil.CollisionMode.MAGIC ? scale * 0.7f : scale;
        BloodDataPacket packet = new BloodDataPacket(particleX, particleY, particleZ, dx, dy, dz, color, finalScale, variant, collisionMode, weightMode, stateMode);
        BlockPos pos = new BlockPos((int)particleX, (int)particleY, (int)particleZ);
        PacketHandler.sendToNear((Level)serverLevel, pos, packet);
    }

    public static EntityConfig getDynamicEntityConfig(EntityUtil.SizeInfo sizeInfo, LivingEntity entity, float damageAmount) {
        EntityConfig baseConfig = EntityHurtEvent.getValueForEntitySize(sizeInfo);
        float postDamageHealth = Math.max(0.0f, entity.m_21223_() - damageAmount);
        double healthPercentage = postDamageHealth / entity.m_21233_();
        double missingHealthFactor = 1.0 - healthPercentage;
        double damageRatio = damageAmount / entity.m_21233_();
        double spreadMultiplier = Math.min(2.0, damageRatio);
        double speedMultiplier = Math.min(3.0, damageRatio);
        if (entity.m_20069_()) {
            spreadMultiplier *= 3.0;
            speedMultiplier *= 0.15;
        }
        float dynamicScale = baseConfig.maxScale * (float)missingHealthFactor;
        int dynamicCount = (int)((double)baseConfig.maxCount * missingHealthFactor);
        float dynamicSpread = baseConfig.spread * (float)spreadMultiplier;
        float dynamicYSpeed = baseConfig.ySpeed * (float)speedMultiplier;
        return new EntityConfig(dynamicScale, dynamicCount, dynamicSpread, dynamicYSpeed);
    }

    public static EntityConfig getValueForEntitySize(EntityUtil.SizeInfo sizeInfo) {
        return switch (sizeInfo.category()) {
            default -> throw new IncompatibleClassChangeError();
            case EntityUtil.SizeCategory.SMALL -> new EntityConfig((float)((Double)ModConfiguration.SMALL_SCALE.get()).doubleValue(), (Integer)ModConfiguration.SMALL_COUNT.get(), (float)((Double)ModConfiguration.SMALL_SPREAD.get()).doubleValue(), 0.2f);
            case EntityUtil.SizeCategory.NORMAL -> new EntityConfig((float)((Double)ModConfiguration.NORMAL_SCALE.get()).doubleValue(), (Integer)ModConfiguration.NORMAL_COUNT.get(), (float)((Double)ModConfiguration.NORMAL_SPREAD.get()).doubleValue(), 0.25f);
            case EntityUtil.SizeCategory.LARGE -> new EntityConfig((float)((Double)ModConfiguration.LARGE_SCALE.get()).doubleValue(), (Integer)ModConfiguration.LARGE_COUNT.get(), (float)((Double)ModConfiguration.LARGE_SPREAD.get()).doubleValue(), 0.3f);
        };
    }

    private static boolean entityTakesWaterDamage(LivingEntity entity) {
        return entity instanceof EnderMan || entity instanceof Blaze;
    }
}

