/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.extragore.particle;

import com.eruannie_9.extragore.particle.BloodParticle;
import com.eruannie_9.extragore.particle.ModParticles;
import com.eruannie_9.extragore.util.EntityUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="extragore", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModFactories {
    public static ThreadLocal<Float> particleScaleThreadLocal = new ThreadLocal();
    public static ThreadLocal<Color> particleColorThreadLocal = new ThreadLocal();
    public static ThreadLocal<EntityUtil.CollisionMode> particleCollisionModeThreadLocal = new ThreadLocal();
    public static ThreadLocal<EntityUtil.WeightMode> particleWeightModeThreadLocal = new ThreadLocal();
    public static ThreadLocal<EntityUtil.StateMode> particleStateModeThreadLocal = new ThreadLocal();

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        engine.m_107378_((ParticleType)ModParticles.BLOOD_PARTICLES_V1.get(), Provider::new);
        engine.m_107378_((ParticleType)ModParticles.BLOOD_PARTICLES_V2.get(), Provider::new);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float sizeScalingFactor = particleScaleThreadLocal.get() != null ? particleScaleThreadLocal.get().floatValue() : 1.0f;
            Color color = particleColorThreadLocal.get();
            EntityUtil.CollisionMode collisionMode = particleCollisionModeThreadLocal.get() != null ? particleCollisionModeThreadLocal.get() : EntityUtil.CollisionMode.NONE;
            EntityUtil.WeightMode weightMode = particleWeightModeThreadLocal.get() != null ? particleWeightModeThreadLocal.get() : EntityUtil.WeightMode.LIGHT;
            EntityUtil.StateMode stateMode = particleStateModeThreadLocal.get() != null ? particleStateModeThreadLocal.get() : EntityUtil.StateMode.LIQUID;
            return new BloodParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, sizeScalingFactor, color, collisionMode, weightMode, stateMode);
        }
    }
}

