/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.registers.RegisterCapability;
import dev.buildtool.kturrets.registers.UnitLimitCapability;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;

public class ContainerItem
extends ForgeSpawnEggItem {
    private final Unit unit;

    public ContainerItem(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor, Item.Properties props, Unit kind) {
        super(type, backgroundColor, highlightColor, props);
        this.unit = kind;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        UUID playerUUID = player.m_20148_();
        if (FMLEnvironment.dist.isDedicatedServer()) {
            UnitLimitCapability unitLimitCapability = (UnitLimitCapability)level.getCapability(RegisterCapability.unitCapability, null).orElse(null);
            if (this.unit == Unit.TURRET) {
                if (unitLimitCapability.getTurretCount(playerUUID) >= (Integer)KTurrets.TURRET_LIMIT_PER_PLAYER.get()) {
                    player.m_5661_((Component)Component.m_237110_((String)"k_turrets.reached.turret.limit", (Object[])new Object[]{KTurrets.TURRET_LIMIT_PER_PLAYER.get()}), false);
                    return InteractionResult.CONSUME;
                }
                unitLimitCapability.setTurretCount(playerUUID, unitLimitCapability.getTurretCount(playerUUID) + 1);
                player.m_5661_((Component)Component.m_237110_((String)"k_turrets.turrets.remain", (Object[])new Object[]{(Integer)KTurrets.TURRET_LIMIT_PER_PLAYER.get() - unitLimitCapability.getTurretCount(playerUUID)}), false);
            } else if (this.unit == Unit.DRONE) {
                if (unitLimitCapability.getDroneCount(playerUUID) >= (Integer)KTurrets.DRONE_LIMIT_PER_PLAYER.get()) {
                    player.m_5661_((Component)Component.m_237110_((String)"k_turrets.reached.drone.limit", (Object[])new Object[]{KTurrets.DRONE_LIMIT_PER_PLAYER.get()}), false);
                    return InteractionResult.CONSUME;
                }
                unitLimitCapability.setDroneCount(playerUUID, unitLimitCapability.getDroneCount(playerUUID) + 1);
                player.m_5661_((Component)Component.m_237110_((String)"k_turrets.drones.remain", (Object[])new Object[]{(Integer)KTurrets.DRONE_LIMIT_PER_PLAYER.get() - unitLimitCapability.getDroneCount(playerUUID)}), false);
            }
        }
        ItemStack itemstack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = level.m_8055_(blockpos);
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)level, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        EntityType entitytype = this.m_43228_(itemstack.m_41783_());
        Entity entity = entitytype.m_20592_((ServerLevel)level, itemstack, context.m_43723_(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (entity != null) {
            if (itemstack.m_41782_()) {
                entity.deserializeNBT(itemstack.m_41783_().m_128469_("Contained"));
                entity.m_20248_((double)blockpos1.m_123341_() + 0.5, (double)(blockpos.m_123342_() + 1), (double)blockpos.m_123343_() + 0.5);
            } else if (((Boolean)KTurrets.SET_OWNER_AUTO.get()).booleanValue()) {
                Turret turret = (Turret)entity;
                turret.setOwner(playerUUID);
            }
            itemstack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level pLevel, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, pLevel, components, tooltipFlag);
        if (itemStack.m_41782_()) {
            components.add((Component)Component.m_237115_((String)"k_turrets.deployed"));
        }
    }

    public static enum Unit {
        TURRET,
        DRONE;

    }
}

