/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.DroneMovementControl;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.registers.KItems;
import dev.buildtool.kturrets.registers.KTBlocks;
import dev.buildtool.kturrets.registers.Sounds;
import dev.buildtool.kturrets.storage.StorageDrone;
import dev.buildtool.kturrets.tasks.AvoidAggressors;
import dev.buildtool.kturrets.tasks.FollowOwnerGoal;
import dev.buildtool.kturrets.tasks.GuardArea;
import dev.buildtool.kturrets.tasks.MoveOutOfLava;
import dev.buildtool.kturrets.tasks.StrafeAroundTarget;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Drone
extends Turret {
    private static final EntityDataAccessor<BlockPos> GUARD_POSITION = SynchedEntityData.m_135353_(Drone.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Byte> BEHAVIOR = SynchedEntityData.m_135353_(Drone.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private BlockPos previousPosition = BlockPos.f_121853_;
    public ItemHandler upgrades = new ItemHandler(5){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.m_150930_((Item)KItems.RECALL_UPGRADE.get())) {
                return !Functions.contains((Item)((Item)KItems.RECALL_UPGRADE.get()), (IItemHandler)this);
            }
            if (stack.m_150930_((Item)KItems.MAGNET_UPGRADE.get())) {
                return Drone.this instanceof StorageDrone && !Functions.contains((Item)((Item)KItems.MAGNET_UPGRADE.get()), (IItemHandler)this);
            }
            if (stack.m_150930_((Item)KItems.LIGHT_UPGRADE.get())) {
                return !Functions.contains((Item)((Item)KItems.LIGHT_UPGRADE.get()), (IItemHandler)this);
            }
            if (stack.m_150930_((Item)KItems.EXP_LINK.get())) {
                return !(Drone.this instanceof StorageDrone) && !Functions.contains((Item)((Item)KItems.EXP_LINK.get()), (IItemHandler)this);
            }
            if (stack.m_150930_((Item)KItems.FIRE_SHIELD.get())) {
                return !Functions.contains((Item)((Item)KItems.FIRE_SHIELD.get()), (IItemHandler)this);
            }
            if (stack.m_150930_((Item)KItems.LOOTING_LINK.get())) {
                return !Functions.contains((Item)((Item)KItems.LOOTING_LINK.get()), (IItemHandler)this);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public Drone(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new DroneMovementControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
    }

    public boolean m_142535_(float p_147105_, float p_147106_, DamageSource p_147107_) {
        return false;
    }

    protected void m_7840_(double p_20809_, boolean p_20810_, BlockState p_20811_, BlockPos p_20812_) {
    }

    public void m_7023_(Vec3 vector) {
        float flyingSpeed = this.m_6113_();
        if (this.m_20069_()) {
            this.m_19920_(flyingSpeed / 2.0f, vector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(flyingSpeed / 2.0f, vector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockPos ground = new BlockPos((int)this.m_20185_(), (int)this.m_20186_() - 1, (int)this.m_20189_());
            float f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
            }
            float f1 = (float)(this.m_21133_(Attributes.f_22279_) / (double)(f * f * f));
            f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
            }
            this.m_19920_(this.m_20096_() ? 0.1f * f1 : flyingSpeed, vector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
        this.m_267651_(false);
    }

    public boolean m_6147_() {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135381_(MOVEABLE, (Object)true);
        this.f_19804_.m_135372_(GUARD_POSITION, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135381_(REFILL_INVENTORY, (Object)false);
        this.f_19804_.m_135372_(BEHAVIOR, (Object)0);
    }

    public void setBehavior(Behavior behavior) {
        this.f_19804_.m_135381_(BEHAVIOR, (Object)((byte)behavior.ordinal()));
    }

    public Behavior getBehavior() {
        return Behavior.values()[(Byte)this.f_19804_.m_135370_(BEHAVIOR)];
    }

    public BlockPos getGuardPosition() {
        return (BlockPos)this.f_19804_.m_135370_(GUARD_POSITION);
    }

    public void setGuardPosition(BlockPos pos) {
        this.f_19804_.m_135381_(GUARD_POSITION, (Object)pos);
    }

    @Override
    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128356_("Guard position", this.getGuardPosition().m_121878_());
        compoundNBT.m_128344_("Behavior", (byte)this.getBehavior().ordinal());
        compoundNBT.m_128365_("Upgrades", (Tag)this.upgrades.serializeNBT());
        compoundNBT.m_128356_("Previous light position", this.previousPosition.m_121878_());
    }

    @Override
    public void m_7378_(CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        this.setGuardPosition(BlockPos.m_122022_((long)compoundNBT.m_128454_("Guard position")));
        this.setBehavior(Behavior.values()[compoundNBT.m_128445_("Behavior")]);
        this.upgrades.deserializeNBT(compoundNBT.m_128469_("Upgrades"));
        this.upgrades.setSize(5);
        this.previousPosition = BlockPos.m_122022_((long)compoundNBT.m_128454_("Previous light position"));
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveOutOfLava(this));
        this.f_21345_.m_25352_(6, (Goal)new AvoidAggressors(this));
        this.f_21345_.m_25352_(7, (Goal)new StrafeAroundTarget(this));
        this.f_21345_.m_25352_(8, (Goal)new GuardArea(this));
    }

    protected PathNavigation m_6037_(Level p_21480_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_21480_);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return this.m_20206_() * 0.4f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (FMLEnvironment.dist.isClient()) {
            return (Boolean)KTurrets.ENABLE_DRONE_SOUND.get() != false ? (SoundEvent)Sounds.DRONE_FLY.get() : null;
        }
        return null;
    }

    public int m_8100_() {
        return 330;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    @Override
    protected float getHealthRecovered() {
        return this.m_21233_() / 4.0f;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Override
    protected abstract List<ItemHandler> getContainedItems();

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_9236_().m_46467_() % 40L == 0L && !Functions.findItem((Item)((Item)KItems.RECALL_UPGRADE.get()), (IItemHandler)this.upgrades).m_41619_()) {
                this.getOwner().ifPresent(uuid1 -> {
                    Player player = this.m_9236_().m_46003_(uuid1);
                    if (player != null && (this.getBehavior() == Behavior.FOLLOW_AND_ATTACK || this.getBehavior() == Behavior.FOLLOW_ONLY) && this.m_20270_((Entity)player) > 128.0f) {
                        this.m_6021_(player.m_20185_(), player.m_20186_() + 2.0, player.m_20189_());
                    }
                });
            }
            if (!Functions.findItem((Item)((Item)KItems.LIGHT_UPGRADE.get()), (IItemHandler)this.upgrades).m_41619_()) {
                BlockPos currentPos = this.m_20097_();
                if (this.m_9236_().m_46859_(currentPos)) {
                    if (this.m_9236_().m_8055_(this.previousPosition).m_60713_((Block)KTBlocks.LIGHT_BLOCK.get())) {
                        this.m_9236_().m_7471_(this.previousPosition, false);
                    }
                    this.m_9236_().m_7731_(currentPos, ((Block)KTBlocks.LIGHT_BLOCK.get()).m_49966_(), 2);
                    this.previousPosition = currentPos;
                }
            } else if (this.m_9236_().m_8055_(this.previousPosition).m_60713_((Block)KTBlocks.LIGHT_BLOCK.get())) {
                this.m_9236_().m_7471_(this.previousPosition, false);
            }
        }
    }

    @Override
    public boolean m_5825_() {
        return Functions.contains((Item)((Item)KItems.FIRE_SHIELD.get()), (IItemHandler)this.upgrades);
    }

    public static enum Behavior {
        FOLLOW_AND_ATTACK,
        FOLLOW_ONLY,
        GUARD,
        STAY;

    }
}

