/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.buildtool.kturrets.ClientProxy;
import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.MultimapAdapter;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.packets.AddPlayerException;
import dev.buildtool.kturrets.packets.AmmoCheck;
import dev.buildtool.kturrets.packets.ClaimTurret;
import dev.buildtool.kturrets.packets.CompressItems;
import dev.buildtool.kturrets.packets.DismantleTurret;
import dev.buildtool.kturrets.packets.MagnetFilterState;
import dev.buildtool.kturrets.packets.PickupParticles;
import dev.buildtool.kturrets.packets.RemovePlayerException;
import dev.buildtool.kturrets.packets.SetBehavior;
import dev.buildtool.kturrets.packets.SetMagnetState;
import dev.buildtool.kturrets.packets.SetProtectPlayer;
import dev.buildtool.kturrets.packets.SetRefillInventory;
import dev.buildtool.kturrets.packets.SetTarget;
import dev.buildtool.kturrets.packets.ToggleMobility;
import dev.buildtool.kturrets.packets.TogglePlayerProtection;
import dev.buildtool.kturrets.packets.TurretTargets;
import dev.buildtool.kturrets.registers.KItems;
import dev.buildtool.kturrets.registers.KTBlockEntities;
import dev.buildtool.kturrets.registers.KTBlocks;
import dev.buildtool.kturrets.registers.KTContainers;
import dev.buildtool.kturrets.registers.KTEntities;
import dev.buildtool.kturrets.registers.RegisterCapability;
import dev.buildtool.kturrets.registers.Sounds;
import dev.buildtool.kturrets.registers.UnitLimitCapability;
import dev.buildtool.kturrets.storage.StorageDrone;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.Methods;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="k_turrets")
public class KTurrets {
    public static final String ID = "k_turrets";
    public static final ResourceLocation TITANIUM_INGOT = new ResourceLocation("forge", "ingots/titanium");
    public static final IntegerColor upgradeSlotColor = new IntegerColor(-668091);
    private static final String NP = "1.0";
    public static final Type TYPE = new TypeToken<ArrayListMultimap<UUID, String>>(){}.getType();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(TYPE, (Object)new MultimapAdapter()).create();
    public static final String FILTER = "Filter";
    public static SimpleChannel channel;
    public static ForgeConfigSpec.DoubleValue ARROW_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue ARROW_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue ARROW_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue ARROW_TURRET_DAMAGE;
    public static ForgeConfigSpec.IntValue ARROW_TURRET_RATE;
    public static ForgeConfigSpec.IntValue BULLET_TURRET_RATE;
    public static ForgeConfigSpec.IntValue FIREBALL_TURRET_RATE;
    public static ForgeConfigSpec.DoubleValue BULLET_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue BULLET_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue BULLET_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue IRON_BULLET_DAMAGE;
    public static ForgeConfigSpec.DoubleValue FIREBALL_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue FIREBALL_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue FIREBALL_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue FIREBALL_TURRET_DAMAGE;
    public static ForgeConfigSpec.DoubleValue BRICK_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue BRICK_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue BRICK_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue BRICK_DAMAGE;
    public static ForgeConfigSpec.IntValue BRICK_TURRET_RATE;
    public static ForgeConfigSpec.DoubleValue GAUSS_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue GAUSS_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue GAUSS_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue GAUSS_TURRET_DAMAGE;
    public static ForgeConfigSpec.IntValue GAUSS_TURRET_RATE;
    public static ForgeConfigSpec.DoubleValue COBBLE_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue COBBLE_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue COBBLE_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue COBBLE_TURRET_DAMAGE;
    public static ForgeConfigSpec.IntValue COBBLE_TURRET_RATE;
    public static ForgeConfigSpec.BooleanValue ENABLE_DRONE_SOUND;
    public static ForgeConfigSpec.BooleanValue SHOW_INTEGRITY;
    public static ForgeConfigSpec.IntValue TURRET_LIMIT_PER_PLAYER;
    public static ForgeConfigSpec.IntValue DRONE_LIMIT_PER_PLAYER;
    public static ForgeConfigSpec.DoubleValue PROJECTILE_SPEED;
    public static ForgeConfigSpec.ConfigValue<List<?>> TARGET_EXCEPTIONS;
    public static ForgeConfigSpec.BooleanValue SET_OWNER_AUTO;
    public static ForgeConfigSpec.IntValue OWNER_FOLLOW_DISTANCE;
    public static ForgeConfigSpec.DoubleValue STORAGE_DRONE_HEALTH;
    public static ForgeConfigSpec.DoubleValue STORAGE_DRONE_ARMOR;
    public static DeferredRegister<CreativeModeTab> TAB_REGISTER;
    public static TagKey<Item> COBBLE_UNIT_AMMO_TAG;
    public static TagKey<Item> ARROW_UNIT_AMMO_TAG;
    public static TagKey<Item> BRICK_UNIT_AMMO_TAG;
    public static TagKey<Item> BULLET_UNIT_AMMO_TAG;
    public static TagKey<Item> FIREBALL_UNIT_AMMO;
    public static TagKey<Item> GAUSS_UNIT_AMMO_TAG;
    public static Logger logger;
    public static ArrayListMultimap<String, String> serverUnitDeaths;
    public static final int turretSlotCount = 29;
    public static final int turretUpgradeCount = 3;
    public static final int droneSlotCount = 23;
    public static final int droneUpgradeCount = 5;
    public static HashMap<ResourceLocation, Pair<Item, NumberProvider>> playerDependentLoot;

    public KTurrets() {
        CreativeModeTab creativeModeTab = CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)ID)).m_257737_(() -> new ItemStack((ItemLike)KItems.GAUSS_TURRET.get())).m_257501_((p_270258_, items) -> {
            items.m_246326_((ItemLike)KItems.COBBLE_TURRET.get());
            items.m_246326_((ItemLike)KItems.ARROW_TURRET.get());
            items.m_246326_((ItemLike)KItems.FIRECHARGE_TURRET.get());
            items.m_246326_((ItemLike)KItems.BULLET_TURRET.get());
            items.m_246326_((ItemLike)KItems.BRICK_TURRET.get());
            items.m_246326_((ItemLike)KItems.GAUSS_TURRET.get());
            items.m_246326_((ItemLike)KItems.EXPLOSIVE_POWDER.get());
            items.m_246326_((ItemLike)KItems.GAUSS_BULLET.get());
            items.m_246326_((ItemLike)KItems.BULLET.get());
            items.m_246326_((ItemLike)KItems.TITANIUM_ORE.get());
            items.m_246326_((ItemLike)KItems.DEEPSLATE_TITANIUM_ORE.get());
            items.m_246326_((ItemLike)KItems.RAW_TITANIUM.get());
            items.m_246326_((ItemLike)KItems.TITANIUM_INGOT.get());
            items.m_246326_((ItemLike)KItems.COPPER_PLATE.get());
            items.m_246326_((ItemLike)KItems.TARGET_COPIER.get());
            items.m_246326_((ItemLike)KItems.COBBLE_DRONE.get());
            items.m_246326_((ItemLike)KItems.ARROW_DRONE.get());
            items.m_246326_((ItemLike)KItems.FIREBALL_DRONE.get());
            items.m_246326_((ItemLike)KItems.BULLET_DRONE.get());
            items.m_246326_((ItemLike)KItems.BRICK_DRONE.get());
            items.m_246326_((ItemLike)KItems.GAUSS_DRONE.get());
            items.m_246326_((ItemLike)KItems.RELOADER.get());
            items.m_246326_((ItemLike)KItems.STORAGE_DRONE.get());
            items.m_246326_((ItemLike)KItems.LIGHT_UPGRADE.get());
            items.m_246326_((ItemLike)KItems.MAGNET_UPGRADE.get());
            items.m_246326_((ItemLike)KItems.RECALL_UPGRADE.get());
            items.m_246326_((ItemLike)KItems.EXP_LINK.get());
            items.m_246326_((ItemLike)KItems.FIRE_SHIELD.get());
            items.m_246326_((ItemLike)KItems.LOOTING_LINK.get());
        }).m_257652_();
        TAB_REGISTER.register("only", () -> creativeModeTab);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        KTEntities.ENTITIES.register(eventBus);
        KItems.ITEMS.register(eventBus);
        KTContainers.CONTAINERS.register(eventBus);
        Sounds.SOUNDS.register(eventBus);
        KTBlocks.BLOCKS.register(eventBus);
        TAB_REGISTER.register(eventBus);
        KTBlockEntities.BLOCK_ENTITIES.register(eventBus);
        Pair pair = new ForgeConfigSpec.Builder().configure(builder -> {
            builder.push("Common");
            PROJECTILE_SPEED = builder.defineInRange("Turret and drone projectile speed", 50.0, 0.1, 50.0);
            TARGET_EXCEPTIONS = builder.comment("List of mob ids to be excluded from default targets").defineList("Target list exceptions", Collections.singletonList("minecraft:zombified_piglin"), o -> o instanceof String && ((String)o).contains(":"));
            SET_OWNER_AUTO = builder.define("Set ownership automatically", true);
            OWNER_FOLLOW_DISTANCE = builder.defineInRange("Drones will keep to the owner at such distance", 30, 1, 128);
            builder.pop();
            builder.push("Turret stats");
            builder.push("Arrow turret");
            ARROW_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, Double.MAX_VALUE);
            ARROW_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 128.0);
            ARROW_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            ARROW_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 1, 60);
            ARROW_TURRET_DAMAGE = builder.defineInRange("Base damage", 6, 1, 100);
            builder.pop();
            builder.push("Bullet turret");
            BULLET_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, Double.MAX_VALUE);
            BULLET_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 128.0);
            BULLET_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            BULLET_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 1, 60);
            IRON_BULLET_DAMAGE = builder.defineInRange("Iron bullet damage", 8, 1, 100);
            builder.pop();
            builder.push("Fire charge turret");
            FIREBALL_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, Double.MAX_VALUE);
            FIREBALL_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 128.0);
            FIREBALL_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            FIREBALL_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 1, 60);
            FIREBALL_TURRET_DAMAGE = builder.defineInRange("Damage", 6, 1, 100);
            builder.pop();
            builder.push("Brick turret");
            BRICK_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, Double.MAX_VALUE);
            BRICK_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 128.0);
            BRICK_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            BRICK_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 1, 60);
            BRICK_DAMAGE = builder.defineInRange("Brick damage", 9, 1, 100);
            builder.pop();
            builder.push("Gauss turret");
            GAUSS_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, Double.MAX_VALUE);
            GAUSS_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 128.0);
            GAUSS_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            GAUSS_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 1, 60);
            GAUSS_TURRET_DAMAGE = builder.defineInRange("Damage", 12, 1, 100);
            builder.pop();
            builder.push("Cobble turret");
            COBBLE_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, Double.MAX_VALUE);
            COBBLE_TURRET_RANGE = builder.defineInRange("Range", 32.0, 0.0, 128.0);
            COBBLE_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            COBBLE_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 1, 60);
            COBBLE_TURRET_DAMAGE = builder.defineInRange("Damage", 3, 1, 100);
            builder.pop();
            builder.push("Storage drone");
            STORAGE_DRONE_HEALTH = builder.defineInRange("Health", 50.0, 10.0, Double.MAX_VALUE);
            STORAGE_DRONE_ARMOR = builder.defineInRange("Armor", 0.0, 0.0, 100.0);
            builder.pop();
            builder.pop();
            return builder.build();
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)pair.getRight());
        Methods.loadConfig((Pair)pair, (String)"k_turrets-common.toml");
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(ID, "network"), () -> NP, NP::equals, NP::equals);
        int packetIndex = 0;
        channel.registerMessage(packetIndex++, TurretTargets.class, (turretTargets, packetBuffer) -> {
            packetBuffer.writeInt(turretTargets.turretID);
            packetBuffer.m_130079_(turretTargets.targets);
        }, packetBuffer -> {
            int id = packetBuffer.readInt();
            CompoundTag compoundNBT = packetBuffer.m_130260_();
            return new TurretTargets(compoundNBT, id);
        }, (turretTargets, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            ServerPlayer sender = context.getSender();
            ServerLevel serverWorld = sender.m_284548_();
            Entity entity = serverWorld.m_6815_(turretTargets.turretID);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setTargets(turretTargets.targets);
                context.setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, DismantleTurret.class, (dismantleTurret, packetBuffer) -> packetBuffer.writeInt(dismantleTurret.id), packetBuffer -> new DismantleTurret(packetBuffer.readInt()), (dismantleTurret, contextSupplier) -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ServerLevel serverWorld = serverPlayer.m_284548_();
            Entity entity = serverWorld.m_6815_(dismantleTurret.id);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.m_146870_();
                UUID uuid = serverPlayer.m_20148_();
                ItemStack egg = new ItemStack((ItemLike)Objects.requireNonNull(ForgeSpawnEggItem.fromEntityType((EntityType)turret.m_6095_())));
                egg.m_41784_().m_128365_("Contained", (Tag)turret.serializeNBT());
                serverWorld.m_7967_((Entity)new ItemEntity((Level)serverWorld, turret.m_20185_(), turret.m_20186_(), turret.m_20189_(), egg));
                if (FMLEnvironment.dist.isDedicatedServer()) {
                    UnitLimitCapability limitCapability = (UnitLimitCapability)serverWorld.getCapability(RegisterCapability.unitCapability, null).orElse(null);
                    if (entity instanceof Drone) {
                        limitCapability.setDroneCount(uuid, limitCapability.getDroneCount(uuid) - 1);
                    } else {
                        limitCapability.setTurretCount(uuid, limitCapability.getTurretCount(uuid) - 1);
                    }
                }
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, ClaimTurret.class, (claimTurret, packetBuffer) -> {
            packetBuffer.writeInt(claimTurret.id);
            packetBuffer.m_130077_(claimTurret.person);
        }, packetBuffer -> new ClaimTurret(packetBuffer.readInt(), packetBuffer.m_130259_()), (claimTurret, contextSupplier) -> {
            ServerLevel serverWorld = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverWorld.m_6815_(claimTurret.id);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setOwner(claimTurret.person);
                turret.setOwnerName(((NetworkEvent.Context)contextSupplier.get()).getSender().m_7755_().getString());
                if (turret instanceof Drone) {
                    ((NetworkEvent.Context)contextSupplier.get()).getSender().m_5661_((Component)Component.m_237115_((String)"k_turrets.drone_claimed"), true);
                } else {
                    ((NetworkEvent.Context)contextSupplier.get()).getSender().m_5661_((Component)Component.m_237115_((String)"k_turrets.turret_claimed"), true);
                }
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, ToggleMobility.class, (toggleMobility, packetBuffer) -> {
            packetBuffer.writeInt(toggleMobility.id);
            packetBuffer.writeBoolean(toggleMobility.mobile);
        }, packetBuffer -> {
            int id = packetBuffer.readInt();
            boolean mobile = packetBuffer.readBoolean();
            return new ToggleMobility(mobile, id);
        }, (toggleMobility, contextSupplier) -> {
            ServerLevel serverWorld = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverWorld.m_6815_(toggleMobility.id);
            if (entity instanceof Turret) {
                ((Turret)entity).setMoveable(toggleMobility.mobile);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, TogglePlayerProtection.class, (togglePlayerProtection, packetBuffer) -> {
            packetBuffer.writeBoolean(togglePlayerProtection.protect);
            packetBuffer.writeInt(togglePlayerProtection.id);
        }, packetBuffer -> new TogglePlayerProtection(packetBuffer.readBoolean(), packetBuffer.readInt()), (togglePlayerProtection, contextSupplier) -> {
            ServerLevel serverWorld = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverWorld.m_6815_(togglePlayerProtection.id);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setProtectionFromPlayers(togglePlayerProtection.protect);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, AddPlayerException.class, (e, friendlyByteBuf) -> {
            friendlyByteBuf.writeInt(e.turretId);
            friendlyByteBuf.m_130070_(e.playerName);
        }, friendlyByteBuf -> new AddPlayerException(friendlyByteBuf.readInt(), friendlyByteBuf.m_130277_()), (e, contextSupplier) -> {
            ServerLevel serverLevel = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverLevel.m_6815_(e.turretId);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.addPlayerToExceptions(e.playerName);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, RemovePlayerException.class, (e, friendlyByteBuf) -> {
            friendlyByteBuf.writeInt(e.turretId);
            friendlyByteBuf.m_130070_(e.playerName);
        }, friendlyByteBuf -> new RemovePlayerException(friendlyByteBuf.readInt(), friendlyByteBuf.m_130277_()), (e, contextSupplier) -> {
            ServerLevel serverLevel = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverLevel.m_6815_(e.turretId);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.removePlayerFromExceptions(e.playerName);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, SetRefillInventory.class, (setRefillInventory, friendlyByteBuf) -> {
            friendlyByteBuf.writeBoolean(setRefillInventory.refill);
            friendlyByteBuf.writeInt(setRefillInventory.turretId);
        }, friendlyByteBuf -> new SetRefillInventory(friendlyByteBuf.readBoolean(), friendlyByteBuf.readInt()), (setRefillInventory, contextSupplier) -> {
            ServerLevel serverLevel = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverLevel.m_6815_(setRefillInventory.turretId);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setRefillInventory(setRefillInventory.refill);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, AmmoCheck.class, (ammoCheck, byteBuf) -> {
            byteBuf.writeInt(ammoCheck.unit);
            byteBuf.writeBoolean(ammoCheck.noAmmo);
        }, byteBuf -> {
            int ammo = byteBuf.readInt();
            return new AmmoCheck(byteBuf.readBoolean(), ammo);
        }, (ammoCheck, contextSupplier) -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> KTurrets.lambda$new$32((Supplier)contextSupplier, ammoCheck)));
        channel.registerMessage(packetIndex++, SetMagnetState.class, (setMagnetState, byteBuf) -> {
            byteBuf.writeInt(setMagnetState.droneId);
            byteBuf.writeBoolean(setMagnetState.state);
        }, byteBuf -> new SetMagnetState(byteBuf.readInt(), byteBuf.readBoolean()), (setMagnetState, contextSupplier) -> ((NetworkEvent.Context)contextSupplier.get()).enqueueWork(() -> KTurrets.lambda$new$36((Supplier)contextSupplier, setMagnetState)));
        channel.registerMessage(packetIndex++, MagnetFilterState.class, (magnetFilterState, byteBuf) -> byteBuf.writeBoolean(magnetFilterState.state), byteBuf -> new MagnetFilterState(byteBuf.readBoolean()), (magnetFilterState, contextSupplier) -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ItemStack held = serverPlayer.m_150109_().m_36056_();
            if (held.m_150930_((Item)KItems.MAGNET_UPGRADE.get())) {
                held.m_41784_().m_128379_(FILTER, magnetFilterState.state);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, SetTarget.class, (setTarget, byteBuf) -> {
            byteBuf.writeInt(setTarget.unit);
            byteBuf.writeBoolean(setTarget.state);
            byteBuf.m_130070_(setTarget.id);
        }, byteBuf -> {
            int unit = byteBuf.readInt();
            boolean state = byteBuf.readBoolean();
            String id = byteBuf.m_130277_();
            return new SetTarget(state, id, unit);
        }, (setTarget, contextSupplier) -> {
            ServerLevel serverLevel = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverLevel.m_6815_(setTarget.unit);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                List<EntityType<?>> targets = Turret.decodeTargets(turret.getTargets());
                if (setTarget.state) {
                    targets.add((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(setTarget.id)));
                } else {
                    targets.remove(ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(setTarget.id)));
                }
                turret.setTargets(Turret.encodeTargets(targets));
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, SetBehavior.class, (setBehavior, byteBuf) -> {
            byteBuf.writeInt(setBehavior.drone);
            byteBuf.m_130068_((Enum)setBehavior.behavior);
        }, byteBuf -> new SetBehavior(byteBuf.readInt(), (Drone.Behavior)byteBuf.m_130066_(Drone.Behavior.class)), (setBehavior, contextSupplier) -> {
            ServerLevel serverLevel = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverLevel.m_6815_(setBehavior.drone);
            if (entity instanceof Drone) {
                Drone drone = (Drone)entity;
                drone.setBehavior(setBehavior.behavior);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, PickupParticles.class, (pickupParticles, byteBuf) -> {
            byteBuf.writeDouble(pickupParticles.x);
            byteBuf.writeDouble(pickupParticles.y);
            byteBuf.writeDouble(pickupParticles.z);
        }, byteBuf -> new PickupParticles(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble()), (pickupParticles, contextSupplier) -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> KTurrets.lambda$new$49((Supplier)contextSupplier, pickupParticles)));
        channel.registerMessage(packetIndex++, SetProtectPlayer.class, (setProtectPlayer, byteBuf) -> {
            byteBuf.writeInt(setProtectPlayer.unitId);
            byteBuf.writeBoolean(setProtectPlayer.protect);
        }, byteBuf -> new SetProtectPlayer(byteBuf.readInt(), byteBuf.readBoolean()), (setProtectPlayer, contextSupplier) -> {
            ServerLevel serverLevel = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverLevel.m_6815_(setProtectPlayer.unitId);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setProtectOwner(setProtectPlayer.protect);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, CompressItems.class, (compressItems, byteBuf) -> byteBuf.writeInt(compressItems.droneId), byteBuf -> new CompressItems(byteBuf.readInt()), (compressItems, contextSupplier) -> {
            ServerLevel serverLevel = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
            Entity entity = serverLevel.m_6815_(compressItems.droneId);
            if (entity instanceof StorageDrone) {
                StorageDrone storageDrone = (StorageDrone)entity;
                HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>(27);
                for (ItemStack item : storageDrone.itemHandler.getItems()) {
                    itemCounts.merge(item.m_41720_(), item.m_41613_(), Integer::sum);
                }
                CraftingMenu craftingMenu = new CraftingMenu(-1, ((NetworkEvent.Context)contextSupplier.get()).getSender().m_150109_());
                TransientCraftingContainer craftingContainer = new TransientCraftingContainer((AbstractContainerMenu)craftingMenu, 3, 3);
                itemCounts.forEach((arg_0, arg_1) -> KTurrets.lambda$new$60(craftingContainer, serverLevel, (Supplier)contextSupplier, storageDrone, arg_0, arg_1));
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)new ForgeConfigSpec.Builder().configure(builder -> {
            ENABLE_DRONE_SOUND = builder.define("Enable drone flying sound", false);
            SHOW_INTEGRITY = builder.define("Show turret and drone integrity", true);
            return builder.build();
        }).getRight());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)new ForgeConfigSpec.Builder().configure(builder -> {
            TURRET_LIMIT_PER_PLAYER = builder.defineInRange("Turret limit per player", () -> 10, 1, 300);
            DRONE_LIMIT_PER_PLAYER = builder.defineInRange("Drone limit per player", () -> 10, 1, 300);
            return builder.build();
        }).getRight());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent lootTableLoadEvent) {
        LootTable lootTable = lootTableLoadEvent.getTable();
        ResourceLocation lootTableName = lootTableLoadEvent.getName();
        if (lootTableName.m_135815_().contains("entit") && !lootTable.f_79109_.isEmpty()) {
            logger.info("Checking {} loot table", (Object)lootTableName);
            lootTable.f_79109_.forEach(lootPool -> {
                boolean killedByPlayer = false;
                LootItemRandomChanceWithLootingCondition randomChanceWithLootingCondition = null;
                for (LootItemCondition lootItemCondition : lootPool.f_79024_) {
                    if (lootItemCondition instanceof LootItemKilledByPlayerCondition) {
                        killedByPlayer = true;
                    }
                    if (!(lootItemCondition instanceof LootItemRandomChanceWithLootingCondition)) continue;
                    randomChanceWithLootingCondition = (LootItemRandomChanceWithLootingCondition)lootItemCondition;
                }
                if (killedByPlayer) {
                    for (LootItemCondition lootItemCondition : lootPool.f_79023_) {
                        if (!(lootItemCondition instanceof LootItem)) continue;
                        LootItem lootItem = (LootItem)lootItemCondition;
                        Item loot = lootItem.f_79564_;
                        for (LootItemFunction function : lootItem.f_79677_) {
                            if (!(function instanceof SetItemCountFunction)) continue;
                            SetItemCountFunction s = (SetItemCountFunction)function;
                            NumberProvider numberProvider = s.f_80997_;
                            if (numberProvider instanceof ConstantValue) {
                                ConstantValue constantValue = (ConstantValue)numberProvider;
                                float value = constantValue.f_165688_;
                                logger.info("   Including {} with constant set item function {}", (Object)loot, (Object)Float.valueOf(value));
                                playerDependentLoot.put(lootTableName, (Pair<Item, NumberProvider>)Pair.of((Object)loot, (Object)numberProvider));
                                continue;
                            }
                            if (!(numberProvider instanceof UniformGenerator)) continue;
                            UniformGenerator ug = (UniformGenerator)numberProvider;
                            ConstantValue minP = (ConstantValue)ug.f_165774_;
                            ConstantValue maxP = (ConstantValue)ug.f_165775_;
                            logger.info("   Including {} with uniform set item function {} - {}", (Object)loot, (Object)Float.valueOf(minP.f_165688_), (Object)Float.valueOf(maxP.f_165688_));
                            playerDependentLoot.put(lootTableName, (Pair<Item, NumberProvider>)Pair.of((Object)loot, (Object)numberProvider));
                        }
                        if (randomChanceWithLootingCondition == null) continue;
                        float chanceForItem = randomChanceWithLootingCondition.f_81953_ / (float)lootPool.f_79023_.length;
                        logger.info("   Including {} with random looting chance {}", (Object)loot, (Object)Float.valueOf(chanceForItem));
                        playerDependentLoot.put(lootTableName, (Pair<Item, NumberProvider>)Pair.of((Object)loot, (Object)UniformGenerator.m_165780_((float)0.0f, (float)chanceForItem)));
                    }
                } else {
                    logger.info("   Skipping regular loot pool");
                }
            });
        }
    }

    @SubscribeEvent
    public void showAmmo(ServerStartedEvent serverStartedEvent) {
        File dir;
        File file;
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        logger.info("Cobble unit ammo:");
        tags.getTag(COBBLE_UNIT_AMMO_TAG).stream().forEach(item -> logger.info((Object)ForgeRegistries.ITEMS.getKey(item)));
        logger.info("");
        logger.info("Bullet unit ammo:");
        tags.getTag(BULLET_UNIT_AMMO_TAG).stream().forEach(item -> logger.info((Object)ForgeRegistries.ITEMS.getKey(item)));
        logger.info("");
        logger.info("Brick unit ammo:");
        tags.getTag(BRICK_UNIT_AMMO_TAG).stream().forEach(item -> logger.info((Object)ForgeRegistries.ITEMS.getKey(item)));
        logger.info("");
        logger.info("Gauss unit ammo:");
        tags.getTag(GAUSS_UNIT_AMMO_TAG).stream().forEach(item -> logger.info((Object)ForgeRegistries.ITEMS.getKey(item)));
        logger.info("");
        logger.info("Fireball unit ammo:");
        tags.getTag(FIREBALL_UNIT_AMMO).stream().forEach(item -> logger.info((Object)ForgeRegistries.ITEMS.getKey(item)));
        logger.info("");
        logger.info("Arrow unit ammo:");
        tags.getTag(ARROW_UNIT_AMMO_TAG).stream().forEach(item -> logger.info((Object)ForgeRegistries.ITEMS.getKey(item)));
        if (serverStartedEvent.getServer().m_6982_() && (file = new File(dir = serverStartedEvent.getServer().m_6237_(), "k_turrets.json")).exists()) {
            try {
                serverUnitDeaths = (ArrayListMultimap)GSON.fromJson((Reader)new FileReader(file), TYPE);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent serverStoppingEvent) {
        MinecraftServer server = serverStoppingEvent.getServer();
        if (server.m_6982_()) {
            String s = GSON.toJson(serverUnitDeaths, TYPE);
            try {
                Path path = server.m_6237_().toPath().resolve(Path.of("k_turrets.json", new String[0]));
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.createFile(path, new FileAttribute[0]);
                }
                Files.writeString(path, (CharSequence)s, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void notifyPlayer(PlayerEvent.PlayerLoggedInEvent playerLoggedInEvent) {
        String uuid;
        Player player = playerLoggedInEvent.getEntity();
        if (player.m_9236_().m_7654_().m_6982_() && serverUnitDeaths.containsKey((Object)(uuid = player.m_20148_().toString()))) {
            player.m_5661_((Component)Component.m_237113_((String)"[K-Turrets] Some of your units were destroyed while you were offline"), false);
            serverUnitDeaths.get((Object)uuid).forEach(s -> player.m_5661_((Component)Component.m_237113_((String)s), false));
            serverUnitDeaths.removeAll((Object)uuid);
        }
    }

    private static /* synthetic */ void lambda$new$60(TransientCraftingContainer craftingContainer, ServerLevel serverLevel, Supplier contextSupplier, StorageDrone storageDrone, Item item, Integer integer) {
        int i;
        ItemStack stack = new ItemStack((ItemLike)item);
        if (integer > 8) {
            for (i = 0; i < 9; ++i) {
                craftingContainer.m_6836_(i, stack);
            }
        }
        serverLevel.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingContainer, (Level)serverLevel).ifPresent(arg_0 -> KTurrets.lambda$new$57(craftingContainer, serverLevel, (Supplier)contextSupplier, item, integer, storageDrone, arg_0));
        for (i = 0; i < 9; ++i) {
            craftingContainer.m_6836_(i, ItemStack.f_41583_);
        }
        if (integer > 3) {
            craftingContainer.m_6836_(0, stack);
            craftingContainer.m_6836_(1, stack);
            craftingContainer.m_6836_(3, stack);
            craftingContainer.m_6836_(4, stack);
        }
        serverLevel.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingContainer, (Level)serverLevel).ifPresent(arg_0 -> KTurrets.lambda$new$59(craftingContainer, serverLevel, (Supplier)contextSupplier, integer, storageDrone, item, arg_0));
        for (i = 0; i < 5; ++i) {
            craftingContainer.m_6836_(i, ItemStack.f_41583_);
        }
    }

    private static /* synthetic */ void lambda$new$59(TransientCraftingContainer craftingContainer, ServerLevel serverLevel, Supplier contextSupplier, Integer integer, StorageDrone storageDrone, Item item, CraftingRecipe craftingRecipe) {
        ItemStack out = craftingRecipe.m_5874_((Container)craftingContainer, serverLevel.m_9598_());
        if (out.m_246617_(serverLevel.m_246046_()) && !out.m_41619_() && out.m_41613_() == 1) {
            CraftingMenu craftingMenuReverse = new CraftingMenu(-2, ((NetworkEvent.Context)contextSupplier.get()).getSender().m_150109_());
            TransientCraftingContainer craftingContainerReverse = new TransientCraftingContainer((AbstractContainerMenu)craftingMenuReverse, 2, 2);
            craftingContainerReverse.m_6836_(0, out);
            serverLevel.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingContainerReverse, (Level)serverLevel).ifPresent(craftingRecipe1 -> {
                int toMake = integer / 4;
                int toConsume = toMake * 4;
                for (int j = 0; j < toConsume; ++j) {
                    Functions.tryExtractItems((IItemHandler)storageDrone.itemHandler, (ItemStack)new ItemStack((ItemLike)item), (boolean)false);
                }
                for (int i = 0; i < toMake; ++i) {
                    if (!Functions.canInsertItem((IItemHandler)storageDrone.itemHandler, (ItemStack)out)) continue;
                    Functions.tryInsertItem((IItemHandler)storageDrone.itemHandler, (ItemStack)out.m_41777_());
                }
            });
        }
    }

    private static /* synthetic */ void lambda$new$57(TransientCraftingContainer craftingContainer, ServerLevel serverLevel, Supplier contextSupplier, Item item, Integer integer, StorageDrone storageDrone, CraftingRecipe craftingRecipe) {
        ItemStack out = craftingRecipe.m_5874_((Container)craftingContainer, serverLevel.m_9598_());
        if (out.m_246617_(serverLevel.m_246046_()) && !out.m_41619_() && out.m_41613_() == 1) {
            CraftingMenu craftingMenuReverse = new CraftingMenu(-2, ((NetworkEvent.Context)contextSupplier.get()).getSender().m_150109_());
            TransientCraftingContainer craftingContainerReverse = new TransientCraftingContainer((AbstractContainerMenu)craftingMenuReverse, 3, 3);
            craftingContainerReverse.m_6836_(0, out);
            serverLevel.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingContainerReverse, (Level)serverLevel).ifPresent(craftingRecipe1 -> {
                ItemStack reverseOut = craftingRecipe1.m_5874_((Container)craftingContainerReverse, serverLevel.m_9598_());
                if (reverseOut.m_150930_(item)) {
                    int toMake = integer / 9;
                    int toConsume = toMake * 9;
                    for (int j = 0; j < toConsume; ++j) {
                        Functions.tryExtractItems((IItemHandler)storageDrone.itemHandler, (ItemStack)new ItemStack((ItemLike)item), (boolean)false);
                    }
                    for (int i = 0; i < toMake; ++i) {
                        if (!Functions.canInsertItem((IItemHandler)storageDrone.itemHandler, (ItemStack)out)) continue;
                        Functions.tryInsertItem((IItemHandler)storageDrone.itemHandler, (ItemStack)out.m_41777_());
                    }
                }
            });
        }
    }

    private static /* synthetic */ Runnable lambda$new$49(Supplier contextSupplier, PickupParticles pickupParticles) {
        ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        return new ClientProxy().pickupParticles(pickupParticles);
    }

    private static /* synthetic */ void lambda$new$36(Supplier contextSupplier, SetMagnetState setMagnetState) {
        ServerLevel serverLevel = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_284548_();
        Entity drone = serverLevel.m_6815_(setMagnetState.droneId);
        if (drone instanceof StorageDrone) {
            StorageDrone storageDrone = (StorageDrone)drone;
            storageDrone.setMagnetActive(setMagnetState.state);
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        }
    }

    private static /* synthetic */ Runnable lambda$new$32(Supplier contextSupplier, AmmoCheck ammoCheck) {
        ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        return new ClientProxy().syncAmmoStatus(ammoCheck);
    }

    static {
        TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)ID);
        COBBLE_UNIT_AMMO_TAG = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(ID, "cobble_unit_ammo"));
        ARROW_UNIT_AMMO_TAG = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(ID, "arrow_unit_ammo"));
        BRICK_UNIT_AMMO_TAG = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(ID, "brick_unit_ammo"));
        BULLET_UNIT_AMMO_TAG = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(ID, "bullet_unit_ammo"));
        FIREBALL_UNIT_AMMO = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(ID, "fireball_unit_ammo"));
        GAUSS_UNIT_AMMO_TAG = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(ID, "gauss_unit_ammo"));
        logger = LogManager.getLogger((String)"K-Turrets");
        serverUnitDeaths = ArrayListMultimap.create();
        playerDependentLoot = new HashMap();
    }
}

