/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.brick.Brick;
import dev.buildtool.kturrets.bullet.Bullet;
import dev.buildtool.kturrets.cobble.Cobblestone;
import dev.buildtool.kturrets.gauss.GaussBullet;
import dev.buildtool.kturrets.registers.KTDamageTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;

public abstract class PresetProjectile
extends AbstractHurtingProjectile {
    protected static final EntityDataAccessor<Integer> DAMAGE = SynchedEntityData.m_135353_(PresetProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static double MOVEMENT_MULTIPLIER = (Double)KTurrets.PROJECTILE_SPEED.get();

    public PresetProjectile(EntityType<? extends AbstractHurtingProjectile> p_i50173_1_, Level p_i50173_2_) {
        super(p_i50173_1_, p_i50173_2_);
    }

    public PresetProjectile(EntityType<? extends AbstractHurtingProjectile> p_i50175_1_, Turret shooter, double p_i50175_3_, double p_i50175_5_, double p_i50175_7_, Level world) {
        super(p_i50175_1_, (LivingEntity)shooter, p_i50175_3_, p_i50175_5_, p_i50175_7_, world);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
        this.f_36813_ *= MOVEMENT_MULTIPLIER;
        this.f_36814_ *= MOVEMENT_MULTIPLIER;
        this.f_36815_ *= MOVEMENT_MULTIPLIER;
    }

    public PresetProjectile(EntityType<? extends AbstractHurtingProjectile> p_i50175_1_, LivingEntity shooter, double p_i50175_3_, double p_i50175_5_, double p_i50175_7_, Level world) {
        super(p_i50175_1_, shooter, p_i50175_3_, p_i50175_5_, p_i50175_7_, world);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
    }

    protected boolean m_5931_() {
        return false;
    }

    public float m_6884_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8060_(BlockHitResult blockRayTraceResult) {
        super.m_8060_(blockRayTraceResult);
        this.m_146870_();
    }

    protected boolean m_5603_(Entity target) {
        Entity entity = this.m_19749_();
        if (entity instanceof Turret) {
            Turret shooter = (Turret)entity;
            if (target instanceof Player) {
                Player player = (Player)target;
                if (shooter.getOwner().isPresent() && player.m_20148_().equals(shooter.getOwner().get())) {
                    return false;
                }
                return !target.m_7307_((Entity)shooter);
            }
            if (target instanceof Turret) {
                Turret turret = (Turret)target;
                if (shooter.getOwner().isPresent()) {
                    if (turret.getOwner().isPresent()) {
                        return !shooter.getOwner().get().equals(turret.getOwner().get());
                    }
                    return true;
                }
                return true;
            }
            if (target.m_6095_().m_20674_().m_21609_()) {
                return target == shooter.m_5448_();
            }
            return Turret.decodeTargets(shooter.getTargets()).contains(target.m_6095_()) || target == shooter.m_5448_();
        }
        return false;
    }

    protected void m_5790_(EntityHitResult entityRayTraceResult) {
        Entity entity = entityRayTraceResult.m_82443_();
        Entity turret = this.m_19749_();
        assert (turret != null);
        DamageSource damageSource = this.m_9236_().m_269111_().m_269333_((LivingEntity)turret);
        if (this instanceof Brick) {
            damageSource = this.m_9236_().m_269111_().m_269298_(KTDamageTypes.BRICK, turret);
        } else if (this instanceof Bullet) {
            damageSource = this.m_9236_().m_269111_().m_269298_(KTDamageTypes.BULLET, turret);
        } else if (this instanceof GaussBullet) {
            damageSource = this.m_9236_().m_269111_().m_269298_(KTDamageTypes.GAUSS_BULLET, turret);
        } else if (this instanceof Cobblestone) {
            damageSource = this.m_9236_().m_269111_().m_269298_(KTDamageTypes.COBBLESTONE, turret);
        }
        if (entity.m_6469_(damageSource, (float)this.getDamage())) {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)0);
    }

    public void setDamage(int damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)damage);
    }

    public int getDamage() {
        return (Integer)this.f_19804_.m_135370_(DAMAGE);
    }

    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128405_("Damage", this.getDamage());
    }

    public void m_7378_(CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        this.setDamage(compoundNBT.m_128451_("Damage"));
    }
}

