/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.UnitOptionsScreen;
import dev.buildtool.kturrets.packets.AmmoCheck;
import dev.buildtool.kturrets.registers.KItems;
import dev.buildtool.kturrets.registers.RegisterCapability;
import dev.buildtool.kturrets.registers.UnitLimitCapability;
import dev.buildtool.kturrets.storage.StorageDrone;
import dev.buildtool.kturrets.storage.StorageDroneScreen;
import dev.buildtool.kturrets.tasks.RevengeTask;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemHandler;
import dev.buildtool.satako.UniqueList;
import dev.buildtool.satako.clientside.gui.CombinedScreen;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class Turret
extends PathfinderMob
implements RangedAttackMob,
MenuProvider,
Container {
    private static final EntityDataAccessor<CompoundTag> TARGETS = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Boolean> MOVEABLE = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PROTECTION_FROM_PLAYERS = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> TEAM = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<CompoundTag> IGNORED_PLAYERS = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    protected static final EntityDataAccessor<Boolean> REFILL_INVENTORY = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public boolean noAmmo;
    private static final EntityDataAccessor<Boolean> PROTECT_OWNER = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ItemHandler upgrades = new ItemHandler(3){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.m_150930_((Item)KItems.EXP_LINK.get())) {
                return !Functions.contains((Item)((Item)KItems.EXP_LINK.get()), (IItemHandler)this);
            }
            if (stack.m_150930_((Item)KItems.FIRE_SHIELD.get())) {
                return !Functions.contains((Item)((Item)KItems.FIRE_SHIELD.get()), (IItemHandler)this);
            }
            if (stack.m_150930_((Item)KItems.LOOTING_LINK.get())) {
                return !Functions.contains((Item)((Item)KItems.LOOTING_LINK.get()), (IItemHandler)this);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public Predicate<LivingEntity> alienPlayers = livingEntity -> {
        if (this.getOwner().isPresent() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag compoundTag = (CompoundTag)this.f_19804_.m_135370_(IGNORED_PLAYERS);
            for (String key : compoundTag.m_128431_()) {
                if (!compoundTag.m_128461_(key).equals(player.m_7755_().getString())) continue;
                return false;
            }
            return !player.m_20148_().equals(this.getOwner().get()) && !this.m_7307_((Entity)player);
        }
        return false;
    };

    public Turret(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createDefaultAttributes() {
        return Turret.m_21183_().m_22268_(Attributes.f_22280_, 0.27).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        CompoundTag compoundNBT = new CompoundTag();
        ArrayList<EntityType> targets = new ArrayList<EntityType>(ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(entityType1 -> !entityType1.m_20674_().m_21609_()).toList());
        List exceptions = (List)KTurrets.TARGET_EXCEPTIONS.get();
        targets.removeIf(entityType -> exceptions.contains(ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString()));
        for (int i = 0; i < targets.size(); ++i) {
            compoundNBT.m_128359_("Target#" + i, ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)targets.get(i))).toString());
        }
        compoundNBT.m_128405_("Count", targets.size());
        this.f_19804_.m_135372_(TARGETS, (Object)compoundNBT);
        this.f_19804_.m_135372_(OWNER, Optional.empty());
        this.f_19804_.m_135372_(MOVEABLE, (Object)false);
        this.f_19804_.m_135372_(PROTECTION_FROM_PLAYERS, (Object)false);
        this.f_19804_.m_135372_(TEAM, (Object)"");
        this.f_19804_.m_135372_(OWNER_NAME, (Object)"");
        this.f_19804_.m_135372_(IGNORED_PLAYERS, (Object)new CompoundTag());
        this.f_19804_.m_135372_(REFILL_INVENTORY, (Object)true);
        this.f_19804_.m_135372_(PROTECT_OWNER, (Object)true);
    }

    public String getAutomaticTeam() {
        return (String)this.f_19804_.m_135370_(TEAM);
    }

    public void setTeamAutomatically(String team) {
        this.f_19804_.m_135381_(TEAM, (Object)team);
    }

    public void setTargets(CompoundTag compoundNBT) {
        this.f_19804_.m_135381_(TARGETS, (Object)compoundNBT);
    }

    public CompoundTag getTargets() {
        return (CompoundTag)this.f_19804_.m_135370_(TARGETS);
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.f_19804_.m_135370_(OWNER);
    }

    public void setOwner(UUID owner) {
        this.f_19804_.m_135381_(OWNER, Optional.of(owner));
    }

    public void setMoveable(boolean moveable) {
        this.f_19804_.m_135381_(MOVEABLE, (Object)moveable);
    }

    public boolean isMoveable() {
        return (Boolean)this.f_19804_.m_135370_(MOVEABLE);
    }

    public void setProtectionFromPlayers(boolean protect) {
        this.f_19804_.m_135381_(PROTECTION_FROM_PLAYERS, (Object)protect);
    }

    public boolean isProtectingFromPlayers() {
        return (Boolean)this.f_19804_.m_135370_(PROTECTION_FROM_PLAYERS);
    }

    public void setRefillInventory(boolean b) {
        this.f_19804_.m_135381_(REFILL_INVENTORY, (Object)b);
    }

    public boolean isRefillingInventory() {
        return (Boolean)this.f_19804_.m_135370_(REFILL_INVENTORY);
    }

    public boolean isProtectingOwner() {
        return (Boolean)this.f_19804_.m_135370_(PROTECT_OWNER);
    }

    public void setProtectOwner(boolean p) {
        this.f_19804_.m_135381_(PROTECT_OWNER, (Object)p);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new RevengeTask(this, new Class[0]));
    }

    public boolean m_5789_() {
        return false;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot p_184582_1_) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot p_184201_1_, ItemStack p_184201_2_) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected double getRange() {
        return this.m_21133_(Attributes.f_22277_);
    }

    protected float getHealthRecovered() {
        return this.m_21233_() / 6.0f;
    }

    protected InteractionResult m_6071_(Player playerEntity, InteractionHand interactionHand) {
        ItemStack itemInHand = playerEntity.m_21120_(interactionHand);
        if (this.m_21223_() < this.m_21233_() && playerEntity.m_6047_() && itemInHand.m_150930_((Item)KItems.TITANIUM_INGOT.get())) {
            this.m_5634_(this.getHealthRecovered());
            itemInHand.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (this.canUse(playerEntity)) {
            if (playerEntity.m_5647_() != null) {
                this.setTeamAutomatically(playerEntity.m_5647_().m_5758_());
            } else {
                this.setTeamAutomatically("");
            }
            if (this.getOwnerName().isEmpty()) {
                this.setOwnerName(playerEntity.m_7755_().getString());
            }
            if (itemInHand.m_41720_() == KItems.TARGET_COPIER.get() && !(this instanceof StorageDrone)) {
                if (playerEntity.m_6047_()) {
                    CompoundTag compoundTag = itemInHand.m_41784_();
                    compoundTag.m_128365_("Filters", (Tag)this.getTargets());
                    CompoundTag ignoredPlayers = (CompoundTag)this.f_19804_.m_135370_(IGNORED_PLAYERS);
                    compoundTag.m_128365_("Ignored players", (Tag)ignoredPlayers);
                    playerEntity.m_5661_((Component)Component.m_237115_((String)"k_turrets.filters.stored"), true);
                } else if (itemInHand.m_41782_()) {
                    this.setTargets(itemInHand.m_41783_().m_128469_("Filters"));
                    CompoundTag compoundTag = itemInHand.m_41783_();
                    CompoundTag ignoredPlayers = compoundTag.m_128469_("Ignored players");
                    this.f_19804_.m_135381_(IGNORED_PLAYERS, (Object)ignoredPlayers);
                    playerEntity.m_5661_((Component)Component.m_237115_((String)"k_turrets.filters.copied"), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (this instanceof StorageDrone) {
                if (playerEntity.m_6144_()) {
                    if (this.m_9236_().f_46443_) {
                        this.openTargetScreen(true);
                    }
                } else if (!this.m_9236_().f_46443_) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)this, pb -> pb.writeInt(this.m_19879_()));
                }
            } else if (playerEntity.m_6144_()) {
                if (this.m_9236_().f_46443_) {
                    this.openTargetScreen(false);
                }
            } else if (!this.m_9236_().f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)this, packetBuffer -> packetBuffer.writeInt(this.m_19879_()));
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            if (this instanceof Drone) {
                if (this.getOwnerName().isEmpty()) {
                    playerEntity.m_5661_((Component)Component.m_237115_((String)"k_turrets.drone.not.yours"), true);
                } else {
                    playerEntity.m_5661_((Component)Component.m_237115_((String)"k_turrets.drone.belongs.to").m_130946_(" " + this.getOwnerName()), true);
                }
            } else if (this.getOwnerName().isEmpty()) {
                playerEntity.m_5661_((Component)Component.m_237115_((String)"k_turrets.turret.not.yours"), true);
            } else {
                playerEntity.m_5661_((Component)Component.m_237115_((String)"k_turrets.turret.belongs.to").m_130946_(" " + this.getOwnerName()), true);
            }
        }
        return InteractionResult.FAIL;
    }

    protected boolean canUse(Player playerEntity) {
        return this.getOwner().isEmpty() || this.getOwner().get().equals(playerEntity.m_20148_());
    }

    @OnlyIn(value=Dist.CLIENT)
    void openTargetScreen(boolean storageDrone) {
        if (storageDrone) {
            Minecraft.m_91087_().m_91152_((Screen)new StorageDroneScreen((Drone)this));
        } else {
            CombinedScreen screenWrapper;
            UnitOptionsScreen unitOptionsScreen = new UnitOptionsScreen(this);
            unitOptionsScreen.wrapper = screenWrapper = new CombinedScreen((BaseScreen)unitOptionsScreen, unitOptionsScreen::initialize);
            Minecraft.m_91087_().m_91152_((Screen)screenWrapper);
        }
    }

    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128365_("Targets", (Tag)this.getTargets());
        this.getOwner().ifPresent(uuid1 -> compoundNBT.m_128362_("Owner", uuid1));
        compoundNBT.m_128379_("Mobile", this.isMoveable());
        compoundNBT.m_128379_("Player protection", this.isProtectingFromPlayers());
        compoundNBT.m_128359_("Team", this.getAutomaticTeam());
        compoundNBT.m_128359_("Owner name", this.getOwnerName());
        compoundNBT.m_128365_("Exceptions", (Tag)this.f_19804_.m_135370_(IGNORED_PLAYERS));
        compoundNBT.m_128379_("Refill inventory", this.isRefillingInventory());
        compoundNBT.m_128379_("Protect owner", this.isProtectingOwner());
        compoundNBT.m_128365_("Upgrades", (Tag)this.upgrades.serializeNBT());
    }

    public void m_7378_(CompoundTag compoundNBT) {
        UUID uuid;
        super.m_7378_(compoundNBT);
        this.setTargets(compoundNBT.m_128469_("Targets"));
        if (compoundNBT.m_128441_("Owner") && !(uuid = compoundNBT.m_128342_("Owner")).equals(Util.f_137441_)) {
            this.setOwner(uuid);
        }
        this.setMoveable(compoundNBT.m_128471_("Mobile"));
        this.setProtectionFromPlayers(compoundNBT.m_128471_("Player protection"));
        this.setTeamAutomatically(compoundNBT.m_128461_("Team"));
        if (compoundNBT.m_128441_("Owner name")) {
            this.setOwnerName(compoundNBT.m_128461_("Owner name"));
        }
        CompoundTag exceptions = compoundNBT.m_128469_("Exceptions");
        this.f_19804_.m_135381_(IGNORED_PLAYERS, (Object)exceptions);
        this.setTeamAutomatically(compoundNBT.m_128461_("Team"));
        this.setRefillInventory(compoundNBT.m_128471_("Refill inventory"));
        this.setProtectOwner(compoundNBT.m_128471_("Protect owner"));
        this.upgrades.deserializeNBT(compoundNBT.m_128469_("Upgrades"));
        this.upgrades.setSize(3);
    }

    public static List<EntityType<?>> decodeTargets(CompoundTag compoundNBT) {
        int count = compoundNBT.m_128451_("Count");
        ArrayList list = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            String next = compoundNBT.m_128461_("Target#" + i);
            list.add((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(next)));
        }
        return list;
    }

    public static CompoundTag encodeTargets(List<EntityType<?>> list) {
        CompoundTag compoundNBT = new CompoundTag();
        for (int i = 0; i < list.size(); ++i) {
            EntityType<?> entityType = list.get(i);
            compoundNBT.m_128359_("Target#" + i, ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString());
        }
        compoundNBT.m_128405_("Count", list.size());
        return compoundNBT;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.getContainedItems().forEach(itemHandler -> Containers.m_19010_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (NonNullList)itemHandler.getItems()));
        this.getOwner().ifPresent(uuid1 -> {
            if (!this.m_9236_().f_46443_) {
                Player player = this.m_9236_().m_46003_(uuid1);
                if (player != null) {
                    if (damageSource.m_7640_() != null) {
                        MutableComponent deathMessageA = this.m_5446_().m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.was.destroyed.by").m_130946_(" ").m_7220_(damageSource.m_7640_().m_5446_()).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.at").m_130946_(" " + (int)this.m_20185_() + " " + (int)this.m_20186_() + " " + (int)this.m_20189_())));
                        player.m_5661_((Component)deathMessageA, false);
                    } else if (damageSource.m_7639_() != null) {
                        MutableComponent deathMessageB = this.m_5446_().m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.was.destroyed.by").m_130946_(" ").m_7220_(damageSource.m_7639_().m_5446_()).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.at").m_130946_(" " + (int)this.m_20185_() + " " + (int)this.m_20186_() + " " + (int)this.m_20189_())));
                        player.m_5661_((Component)deathMessageB, false);
                    } else {
                        MutableComponent deathMessageC = damageSource.m_6157_((LivingEntity)this).m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.at").m_130946_(" " + (int)this.m_20185_() + " " + (int)this.m_20186_() + " " + (int)this.m_20189_()));
                        player.m_5661_((Component)deathMessageC, false);
                    }
                }
                if (FMLEnvironment.dist.isDedicatedServer()) {
                    MinecraftServer server = this.m_9236_().m_7654_();
                    UnitLimitCapability unitLimitCapability = (UnitLimitCapability)this.m_9236_().getCapability(RegisterCapability.unitCapability).orElse(null);
                    if (this instanceof Drone) {
                        unitLimitCapability.setDroneCount((UUID)uuid1, unitLimitCapability.getDroneCount((UUID)uuid1) - 1);
                    } else {
                        unitLimitCapability.setTurretCount((UUID)uuid1, unitLimitCapability.getTurretCount((UUID)uuid1) - 1);
                    }
                    if (player == null) {
                        if (damageSource.m_7640_() != null) {
                            MutableComponent deathMessageA = this.m_5446_().m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.was.destroyed.by").m_130946_(" ").m_7220_(damageSource.m_7640_().m_5446_()).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.at").m_130946_(" " + (int)this.m_20185_() + " " + (int)this.m_20186_() + " " + (int)this.m_20189_())));
                            KTurrets.serverUnitDeaths.put((Object)uuid1.toString(), (Object)deathMessageA.getString());
                        } else if (damageSource.m_7639_() != null) {
                            MutableComponent deathMessageB = this.m_5446_().m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.was.destroyed.by").m_130946_(" ").m_7220_(damageSource.m_7639_().m_5446_()).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.at").m_130946_(" " + (int)this.m_20185_() + " " + (int)this.m_20186_() + " " + (int)this.m_20189_())));
                            KTurrets.serverUnitDeaths.put((Object)uuid1.toString(), (Object)deathMessageB.getString());
                        } else {
                            MutableComponent deathMessageC = damageSource.m_6157_((LivingEntity)this).m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"k_turrets.at").m_130946_(" " + (int)this.m_20185_() + " " + (int)this.m_20186_() + " " + (int)this.m_20189_()));
                            KTurrets.serverUnitDeaths.put((Object)uuid1.toString(), (Object)deathMessageC.getString());
                        }
                    }
                }
            }
        });
    }

    protected abstract List<ItemHandler> getContainedItems();

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12346_;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == MobEffects.f_19601_ || effect == MobEffects.f_19616_ || effect == MobEffects.f_19605_ || effect == MobEffects.f_19615_ || effect == MobEffects.f_19612_) {
            return false;
        }
        return super.m_7301_(effectInstance);
    }

    public boolean m_5829_() {
        return !this.isMoveable();
    }

    public boolean m_6094_() {
        return this.isMoveable();
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
        if (this.isMoveable()) {
            super.m_147240_(p_147241_, p_147242_, p_147243_);
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11892_;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public boolean m_7307_(Entity target) {
        Turret turret;
        return super.m_7307_(target) || this.getOwner().isPresent() && target.m_20148_().equals(this.getOwner().get()) || target instanceof Turret && (turret = (Turret)target).getOwner().isPresent() && turret.getOwner().equals(this.getOwner());
    }

    public boolean m_6673_(DamageSource p_20122_) {
        Entity source = p_20122_.m_7639_();
        if (source instanceof Player) {
            Player player = (Player)source;
            if (this.getOwner().isPresent() && player.m_20148_().equals(this.getOwner().get())) {
                return true;
            }
        }
        return super.m_6673_(p_20122_);
    }

    public abstract boolean isArmed();

    @Nullable
    public UUID getOwnerUUID() {
        return this.getOwner().isPresent() ? this.getOwner().get() : null;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.getContainedItems().get(0)).cast();
        }
        return super.getCapability(cap, direction);
    }

    public int m_6643_() {
        return this.getContainedItems().get(0).getSlots();
    }

    public boolean m_7983_() {
        return this.getContainedItems().get(0).isEmpty();
    }

    public ItemStack m_8020_(int p_18941_) {
        return this.getContainedItems().get(0).getStackInSlot(p_18941_);
    }

    public ItemStack m_7407_(int p_18942_, int p_18943_) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int p_18951_) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int p_18944_, ItemStack p_18945_) {
        this.getContainedItems().get(0).setStackInSlot(p_18944_, p_18945_);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player p_18946_) {
        return true;
    }

    public void m_6211_() {
        this.getContainedItems().get(0).getItems().clear();
    }

    public boolean m_7013_(int p_18952_, ItemStack p_18953_) {
        return this.getContainedItems().get(0).isItemValid(p_18952_, p_18953_);
    }

    @Nullable
    public Team m_5647_() {
        if (this.getOwner().isPresent()) {
            Player owner = this.m_9236_().m_46003_(this.getOwner().get());
            if (owner != null && owner.m_5647_() != null) {
                return owner.m_5647_();
            }
            return this.getAutomaticTeam().isEmpty() ? null : this.m_9236_().m_6188_().m_83489_(this.getAutomaticTeam());
        }
        return super.m_5647_();
    }

    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(OWNER_NAME, (Object)name);
    }

    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(OWNER_NAME);
    }

    public void addPlayerToExceptions(String name) {
        CompoundTag compoundTag = (CompoundTag)this.f_19804_.m_135370_(IGNORED_PLAYERS);
        for (String key : compoundTag.m_128431_()) {
            String nickname = compoundTag.m_128461_(key);
            if (!nickname.equals(name)) continue;
            return;
        }
        compoundTag.m_128359_("IgnoredPlayer#" + compoundTag.m_128440_(), name);
    }

    public void removePlayerFromExceptions(String name) {
        CompoundTag compoundTag = (CompoundTag)this.f_19804_.m_135370_(IGNORED_PLAYERS);
        for (String key : compoundTag.m_128431_()) {
            String nickname = compoundTag.m_128461_(key);
            if (!nickname.equals(name)) continue;
            compoundTag.m_128473_(key);
            break;
        }
    }

    public List<String> getExceptions() {
        UniqueList exceptions = new UniqueList(1);
        CompoundTag compoundTag = (CompoundTag)this.f_19804_.m_135370_(IGNORED_PLAYERS);
        compoundTag.m_128431_().forEach(arg_0 -> Turret.lambda$getExceptions$9((List)exceptions, compoundTag, arg_0));
        return exceptions;
    }

    public boolean m_5830_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isRefillingInventory()) {
                for (Direction direction : Direction.values()) {
                    BlockPos blockPos = this.m_20183_();
                    BlockEntity sideEntity = this.m_9236_().m_7702_(blockPos.m_121945_(direction));
                    if (sideEntity == null || !sideEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) continue;
                    sideEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                        for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                            ItemHandler itemHandler;
                            ItemStack tryStack = iItemHandler.extractItem(i, 1, true);
                            if (tryStack.m_41619_() || !this.m_7013_(0, tryStack) || !Functions.tryInsertItem((IItemHandler)(itemHandler = this.getContainedItems().get(0)), (ItemStack)tryStack)) continue;
                            iItemHandler.extractItem(i, 1, false);
                            break;
                        }
                    });
                    break;
                }
            }
            if (this.m_9236_().m_46467_() % 30L == 0L) {
                KTurrets.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 22.0, this.m_9236_().m_46472_())), (Object)new AmmoCheck(!this.isArmed(), this.m_19879_()));
            }
        }
    }

    public int getDamage() {
        return 0;
    }

    public int getSecondaryDamage() {
        return 0;
    }

    public boolean m_5825_() {
        return Functions.contains((Item)((Item)KItems.FIRE_SHIELD.get()), (IItemHandler)this.upgrades);
    }

    private static /* synthetic */ void lambda$getExceptions$9(List exceptions, CompoundTag compoundTag, String s) {
        exceptions.add(compoundTag.m_128461_(s));
    }
}

