/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.ButtonListScreen;
import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.packets.AddPlayerException;
import dev.buildtool.kturrets.packets.ClaimTurret;
import dev.buildtool.kturrets.packets.DismantleTurret;
import dev.buildtool.kturrets.packets.RemovePlayerException;
import dev.buildtool.kturrets.packets.SetBehavior;
import dev.buildtool.kturrets.packets.SetProtectPlayer;
import dev.buildtool.kturrets.packets.SetRefillInventory;
import dev.buildtool.kturrets.packets.SetTarget;
import dev.buildtool.kturrets.packets.ToggleMobility;
import dev.buildtool.kturrets.packets.TogglePlayerProtection;
import dev.buildtool.kturrets.packets.TurretTargets;
import dev.buildtool.satako.Constants;
import dev.buildtool.satako.UniqueList;
import dev.buildtool.satako.clientside.gui.BetterButton;
import dev.buildtool.satako.clientside.gui.CombinedScreen;
import dev.buildtool.satako.clientside.gui.DropDownButton;
import dev.buildtool.satako.clientside.gui.Label;
import dev.buildtool.satako.clientside.gui.RadioButton;
import dev.buildtool.satako.clientside.gui.SwitchButton;
import dev.buildtool.satako.clientside.gui.TextField;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class UnitOptionsScreen
extends ButtonListScreen {
    protected Turret turret;
    private final List<Label> suggestions = new ArrayList<Label>(14);
    private final UniqueList<EntityType<?>> targets;
    public CombinedScreen wrapper;
    private final ArrayList<BetterButton> hideableWidgets = new ArrayList();
    private TextField addEntity;
    private final List<String> exceptions = new ArrayList<String>();
    private final ArrayList<TextButton> exceptionButtons = new ArrayList();

    public UnitOptionsScreen(Turret turret) {
        this.turret = turret;
        this.targets = new UniqueList(Turret.decodeTargets(turret.getTargets()));
        this.showBottomPanel(false);
        this.initGui();
        this.setFullscreen();
        this.setTitle((Component)Component.m_237115_((String)"k_turrets.targets"));
        this.exceptions.addAll(turret.getExceptions());
    }

    @Override
    protected void doCancel() {
    }

    @Override
    protected void doAccept() {
    }

    @Override
    public void addButtons(Panel var1) {
        if (!this.exceptions.isEmpty()) {
            dev.ftb.mods.ftblibrary.ui.TextField textField = new dev.ftb.mods.ftblibrary.ui.TextField(var1);
            textField.setText((Component)Component.m_237115_((String)"k_turrets.ignored.players"));
            var1.add((Widget)textField);
        }
        this.exceptions.forEach(s -> {
            TextButton textButton = new TextButton(var1, Component.m_237113_((String)s), true);
            var1.add((Widget)textButton);
            this.exceptionButtons.add(textButton);
        });
        if (!this.exceptions.isEmpty()) {
            dev.ftb.mods.ftblibrary.ui.TextField separator = new dev.ftb.mods.ftblibrary.ui.TextField(var1);
            separator.setHeight(18);
            var1.add((Widget)separator);
        }
        this.targets.sort(Comparator.comparing(o -> ForgeRegistries.ENTITY_TYPES.getKey(o).toString()));
        this.targets.stream().map(entityType -> Component.m_237113_((String)ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString())).map(entityName -> new TextButton(var1, (MutableComponent)entityName, true)).forEach(arg_0 -> ((Panel)var1).add(arg_0));
    }

    public boolean onClosedByKey(Key key) {
        return this.addEntity.m_93696_() ? key.esc() : key.escOrInventory();
    }

    public void initialize() {
        int elementYPos = 10;
        this.addEntity = new TextField(this.width / 2, elementYPos, (Component)Component.m_237119_(), this.width / 2){

            public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
                UnitOptionsScreen.this.suggestions.forEach(arg_0 -> ((CombinedScreen)UnitOptionsScreen.this.wrapper).m_169411_(arg_0));
                UnitOptionsScreen.this.suggestions.clear();
                String text = UnitOptionsScreen.this.addEntity.m_94155_();
                if (!text.isEmpty()) {
                    int yOffset = 20;
                    if (text.startsWith("!")) {
                        List players = UnitOptionsScreen.this.turret.m_9236_().m_6907_();
                        players.remove(Minecraft.m_91087_().f_91074_);
                        for (Player player : players) {
                            Label hint = new Label(UnitOptionsScreen.this.addEntity.m_252754_(), UnitOptionsScreen.this.addEntity.m_252907_() + yOffset, player.m_7755_(), (Screen)UnitOptionsScreen.this.wrapper, button -> {
                                UnitOptionsScreen.this.addEntity.m_94144_("!" + button.m_6035_().getString());
                                UnitOptionsScreen.this.suggestions.forEach(arg_0 -> ((CombinedScreen)UnitOptionsScreen.this.wrapper).m_169411_(arg_0));
                                UnitOptionsScreen.this.suggestions.clear();
                                UnitOptionsScreen.this.hideableWidgets.forEach(betterButton -> betterButton.setHidden(false));
                            }, Constants.BLACK);
                            UnitOptionsScreen.this.wrapper.m_142416_((GuiEventListener)hint);
                            UnitOptionsScreen.this.suggestions.add(hint);
                            yOffset += 14;
                        }
                        if (!players.isEmpty()) {
                            UnitOptionsScreen.this.hideableWidgets.forEach(betterButton -> betterButton.setHidden(true));
                        } else {
                            UnitOptionsScreen.this.hideableWidgets.forEach(betterButton -> betterButton.setHidden(false));
                        }
                    } else {
                        ArrayList<ResourceLocation> entityTypes = new ArrayList<ResourceLocation>(ForgeRegistries.ENTITY_TYPES.getKeys().stream().filter(resourceLocation -> resourceLocation.toString().contains(text)).toList());
                        entityTypes.removeAll(UnitOptionsScreen.this.targets.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getKey(arg_0)).toList());
                        for (ResourceLocation entityType : entityTypes.subList(0, Math.min(entityTypes.size(), 20))) {
                            Label hint = new Label(UnitOptionsScreen.this.addEntity.m_252754_(), UnitOptionsScreen.this.addEntity.m_252907_() + yOffset, (Component)Component.m_237113_((String)(ChatFormatting.YELLOW + entityType.toString())), (Screen)UnitOptionsScreen.this.wrapper, p_93751_ -> {
                                UnitOptionsScreen.this.addEntity.m_94144_(p_93751_.m_6035_().getString().substring(2));
                                UnitOptionsScreen.this.suggestions.forEach(arg_0 -> ((CombinedScreen)UnitOptionsScreen.this.wrapper).m_169411_(arg_0));
                                UnitOptionsScreen.this.suggestions.clear();
                                UnitOptionsScreen.this.hideableWidgets.forEach(betterButton -> betterButton.setHidden(false));
                            }, Constants.BLACK);
                            UnitOptionsScreen.this.wrapper.m_142416_((GuiEventListener)hint);
                            UnitOptionsScreen.this.suggestions.add(hint);
                            yOffset += 14;
                        }
                        if (!entityTypes.isEmpty()) {
                            UnitOptionsScreen.this.hideableWidgets.forEach(betterButton -> betterButton.setHidden(true));
                        } else {
                            UnitOptionsScreen.this.hideableWidgets.forEach(betterButton -> betterButton.setHidden(false));
                        }
                    }
                } else {
                    UnitOptionsScreen.this.hideableWidgets.forEach(betterButton -> betterButton.setHidden(false));
                }
                return true;
            }
        };
        this.wrapper.m_142416_((GuiEventListener)this.addEntity);
        BetterButton addButton = new BetterButton(this.addEntity.m_252754_(), elementYPos += 24, (Component)Component.m_237115_((String)"k_turrets.add.entity.type"), button -> {
            String string = this.addEntity.m_94155_();
            if (string.startsWith("!") && string.length() > 1) {
                String playerName = string.substring(1);
                if (this.exceptions.contains(playerName)) {
                    this.wrapper.addPopup((Component)Component.m_237110_((String)"k_turrets.player.is.already.in.exceptions", (Object[])new Object[]{playerName}));
                } else {
                    this.turret.addPlayerToExceptions(playerName);
                    this.exceptions.add(playerName);
                    KTurrets.channel.sendToServer((Object)new AddPlayerException(this.turret.m_19879_(), playerName));
                    this.addEntity.m_94144_("");
                    this.mainPanel.refreshWidgets();
                }
            } else if (!string.isEmpty()) {
                EntityType entityTypesValue = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(string));
                this.targets.add((Object)entityTypesValue);
                KTurrets.channel.sendToServer((Object)new SetTarget(true, string, this.turret.m_19879_()));
                this.addEntity.m_94144_("");
                this.mainPanel.refreshWidgets();
                this.wrapper.addPopup((Component)Component.m_237115_((String)"k_turrets.added"));
            }
        });
        this.wrapper.m_142416_((GuiEventListener)addButton);
        this.hideableWidgets.add(addButton);
        BetterButton dismantle = new BetterButton(this.addEntity.m_252754_(), elementYPos += 20, (Component)Component.m_237115_((String)"k_turrets.dismantle"), pButton -> {
            this.wrapper.closeGui();
            KTurrets.channel.sendToServer((Object)new DismantleTurret(this.turret.m_19879_()));
        });
        this.wrapper.m_142416_((GuiEventListener)dismantle);
        this.hideableWidgets.add(dismantle);
        BetterButton clearTargets = new BetterButton(this.addEntity.m_252754_(), elementYPos += 20, (Component)Component.m_237115_((String)"k_turrets.clear.list"), pButton -> {
            this.targets.clear();
            this.mainPanel.refreshWidgets();
            KTurrets.channel.sendToServer((Object)new TurretTargets(new CompoundTag(), this.turret.m_19879_()));
        });
        this.wrapper.m_142416_((GuiEventListener)clearTargets);
        this.hideableWidgets.add(clearTargets);
        BetterButton resetTargets = new BetterButton(clearTargets.m_252754_() + clearTargets.getElementWidth(), elementYPos, (Component)Component.m_237115_((String)"k_turrets.reset.list"), pButton -> {
            List<EntityType<?>> entityTypeList = ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(entityType1 -> !entityType1.m_20674_().m_21609_()).toList();
            this.targets.addAll(entityTypeList);
            this.refreshWidgets();
            List<EntityType<?>> entityTypes = Turret.decodeTargets(this.turret.getTargets());
            entityTypes.clear();
            entityTypes.addAll(entityTypeList);
            CompoundTag compoundNBT = Turret.encodeTargets(entityTypeList);
            this.turret.setTargets(compoundNBT);
            KTurrets.channel.sendToServer((Object)new TurretTargets(compoundNBT, this.turret.m_19879_()));
        });
        this.wrapper.m_142416_((GuiEventListener)resetTargets);
        this.hideableWidgets.add(resetTargets);
        SwitchButton mobility = new SwitchButton(this.addEntity.m_252754_(), elementYPos += 20, (Component)Component.m_237115_((String)"k_turrets.mobile"), (Component)Component.m_237115_((String)"k_turrets.immobile"), this.turret.isMoveable(), pButton -> {
            SwitchButton switchButton1 = (SwitchButton)pButton;
            switchButton1.state = !switchButton1.state;
            this.turret.setMoveable(switchButton1.state);
            KTurrets.channel.sendToServer((Object)new ToggleMobility(switchButton1.state, this.turret.m_19879_()));
        });
        this.wrapper.m_142416_((GuiEventListener)mobility);
        this.hideableWidgets.add((BetterButton)mobility);
        mobility.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"k_turrets.pushable")));
        SwitchButton playerProtection = new SwitchButton(this.addEntity.m_252754_(), elementYPos += 20, (Component)Component.m_237115_((String)"k_turrets.protect.from.players"), (Component)Component.m_237115_((String)"k_turrets.not.protect.from.players"), this.turret.isProtectingFromPlayers(), pButton -> {
            SwitchButton switchButton1 = (SwitchButton)pButton;
            switchButton1.state = !switchButton1.state;
            this.turret.setProtectionFromPlayers(switchButton1.state);
            KTurrets.channel.sendToServer((Object)new TogglePlayerProtection(switchButton1.state, this.turret.m_19879_()));
        });
        this.wrapper.m_142416_((GuiEventListener)playerProtection);
        this.hideableWidgets.add((BetterButton)playerProtection);
        playerProtection.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"k_turrets.protection.from.players")));
        SwitchButton refillSwitch = new SwitchButton(this.addEntity.m_252754_(), elementYPos += 20, (Component)Component.m_237115_((String)"k_turrets.refill.inventory"), (Component)Component.m_237115_((String)"k_turrets.dont.refill.inventory"), this.turret.isRefillingInventory(), pButton -> {
            SwitchButton b = (SwitchButton)pButton;
            b.state = !b.state;
            this.turret.setRefillInventory(b.state);
            KTurrets.channel.sendToServer((Object)new SetRefillInventory(b.state, this.turret.m_19879_()));
        });
        this.wrapper.m_142416_((GuiEventListener)refillSwitch);
        this.hideableWidgets.add((BetterButton)refillSwitch);
        refillSwitch.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"k_turrets.refill.info")));
        SwitchButton protectSwitch = new SwitchButton(this.addEntity.m_252754_(), elementYPos += 20, (Component)Component.m_237115_((String)"k_turrets.protect.player"), (Component)Component.m_237115_((String)"k_turrets.do.not.protect.player"), this.turret.isProtectingOwner(), pButton -> {
            SwitchButton switchButton = (SwitchButton)pButton;
            switchButton.state = !switchButton.state;
            this.turret.setProtectOwner(switchButton.state);
            KTurrets.channel.sendToServer((Object)new SetProtectPlayer(this.turret.m_19879_(), switchButton.state));
        });
        this.wrapper.m_142416_((GuiEventListener)protectSwitch);
        this.hideableWidgets.add((BetterButton)protectSwitch);
        protectSwitch.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"k_turrets.player.protection")));
        int finalElementYPos = elementYPos += 20;
        this.turret.getOwner().ifPresentOrElse(uuid -> {
            Turret patt13277$temp = this.turret;
            if (patt13277$temp instanceof Drone) {
                Drone drone = (Drone)patt13277$temp;
                DropDownButton dropDownButton = new DropDownButton(this.addEntity.m_252754_(), finalElementYPos, (Screen)this.wrapper, (Component)Component.m_237113_((String)""));
                LinkedHashMap<Component, Button.OnPress> linkedHashMap = new LinkedHashMap<Component, Button.OnPress>(3);
                RadioButton follow = new RadioButton(this.addEntity.m_252754_(), dropDownButton.m_252907_() + dropDownButton.m_93694_(), (Component)Component.m_237115_((String)"k_turrets.follow_and_attack.owner"));
                linkedHashMap.put(follow.m_6035_(), pButton -> {
                    drone.setBehavior(Drone.Behavior.FOLLOW_AND_ATTACK);
                    dropDownButton.m_5691_();
                    KTurrets.channel.sendToServer((Object)new SetBehavior(drone.m_19879_(), Drone.Behavior.FOLLOW_AND_ATTACK));
                    dropDownButton.m_93666_(pButton.m_6035_());
                });
                RadioButton followOnly = new RadioButton(this.addEntity.m_252754_(), follow.m_252907_() + follow.getElementHeight(), (Component)Component.m_237115_((String)"k_turrets.only.follow"));
                linkedHashMap.put(followOnly.m_6035_(), pButton -> {
                    drone.setBehavior(Drone.Behavior.FOLLOW_ONLY);
                    dropDownButton.m_5691_();
                    KTurrets.channel.sendToServer((Object)new SetBehavior(drone.m_19879_(), Drone.Behavior.FOLLOW_ONLY));
                    dropDownButton.m_93666_(pButton.m_6035_());
                });
                RadioButton guard = new RadioButton(this.addEntity.m_252754_(), followOnly.m_252907_() + followOnly.getElementHeight(), (Component)Component.m_237115_((String)"k_turrets.guard.area"));
                linkedHashMap.put(guard.m_6035_(), pButton -> {
                    drone.setBehavior(Drone.Behavior.GUARD);
                    dropDownButton.m_5691_();
                    KTurrets.channel.sendToServer((Object)new SetBehavior(drone.m_19879_(), Drone.Behavior.GUARD));
                    dropDownButton.m_93666_(pButton.m_6035_());
                });
                RadioButton stay = new RadioButton(this.addEntity.m_252754_(), guard.m_252907_() + guard.getElementHeight(), (Component)Component.m_237115_((String)"k_turrets.staying"));
                linkedHashMap.put(stay.m_6035_(), pButton -> {
                    drone.setBehavior(Drone.Behavior.STAY);
                    dropDownButton.m_5691_();
                    KTurrets.channel.sendToServer((Object)new SetBehavior(drone.m_19879_(), Drone.Behavior.STAY));
                    dropDownButton.m_93666_(pButton.m_6035_());
                });
                dropDownButton.setChoices(linkedHashMap, drone.getBehavior().ordinal());
                this.wrapper.m_142416_((GuiEventListener)dropDownButton);
                this.hideableWidgets.add((BetterButton)dropDownButton);
            }
        }, () -> {
            BetterButton claim = new BetterButton(this.addEntity.m_252754_(), finalElementYPos, (Component)Component.m_237115_((String)"k_turrets.claim.drone"), pButton -> {
                this.turret.setOwner(this.wrapper.getMinecraft().f_91074_.m_20148_());
                this.wrapper.closeGui();
                KTurrets.channel.sendToServer((Object)new ClaimTurret(this.turret.m_19879_(), this.wrapper.getMinecraft().f_91074_.m_20148_()));
            });
            this.wrapper.m_142416_((GuiEventListener)claim);
            this.hideableWidgets.add(claim);
        });
        Label range = new Label(this.addEntity.m_252754_() + 4, elementYPos += 24, (Component)Component.m_237115_((String)"k_turrets.range").m_130946_(": ").m_130946_("" + this.turret.getRange()), Constants.BLACK);
        this.hideableWidgets.add((BetterButton)this.wrapper.m_142416_((GuiEventListener)range));
        Label health = new Label(range.m_252754_(), elementYPos += 18, (Component)Component.m_237115_((String)"k_turrets.integrity").m_130946_(": ").m_130946_(String.format("%.1f", Float.valueOf(this.turret.m_21223_())) + "/" + this.turret.m_21233_()), Constants.BLACK);
        this.hideableWidgets.add((BetterButton)this.wrapper.m_142416_((GuiEventListener)health));
        int primaryDamage = this.turret.getDamage();
        int secondaryDamage = this.turret.getSecondaryDamage();
        MutableComponent damageText = Component.m_237110_((String)"k_turrets.damage", (Object[])new Object[]{primaryDamage});
        if (secondaryDamage > 0) {
            damageText.m_130946_("/" + secondaryDamage);
        }
        Label damage = new Label(range.m_252754_(), elementYPos += 18, (Component)damageText, Constants.BLACK);
        this.hideableWidgets.add((BetterButton)damage);
        this.wrapper.m_142416_((GuiEventListener)damage);
        Label armor = new Label(range.m_252754_(), elementYPos += 18, (Component)Component.m_237110_((String)"k_turrets.armor", (Object[])new Object[]{String.format("%.1f", this.turret.m_21051_(Attributes.f_22284_).m_22135_())}), Constants.BLACK);
        this.hideableWidgets.add((BetterButton)armor);
        this.wrapper.m_142416_((GuiEventListener)armor);
    }

    private class TextButton
    extends SimpleTextButton {
        boolean state;

        public TextButton(Panel var1, MutableComponent entityName, boolean state) {
            super(var1, (Component)entityName, Icons.CHECK);
            this.state = state;
        }

        public void onClicked(MouseButton mouseButton) {
            this.state = !this.state;
            this.setIcon(this.state ? Icons.CHECK : Icons.CLOSE);
            this.playClickSound();
            String string = this.title.getString();
            if (UnitOptionsScreen.this.exceptionButtons.contains((Object)this)) {
                if (this.state) {
                    UnitOptionsScreen.this.turret.addPlayerToExceptions(string);
                    KTurrets.channel.sendToServer((Object)new AddPlayerException(UnitOptionsScreen.this.turret.m_19879_(), string));
                } else {
                    UnitOptionsScreen.this.turret.removePlayerFromExceptions(string);
                    KTurrets.channel.sendToServer((Object)new RemovePlayerException(UnitOptionsScreen.this.turret.m_19879_(), string));
                }
            } else {
                List<EntityType<?>> targets = Turret.decodeTargets(UnitOptionsScreen.this.turret.getTargets());
                if (this.state) {
                    targets.add((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(string)));
                    UnitOptionsScreen.this.turret.setTargets(Turret.encodeTargets(targets));
                }
                KTurrets.channel.sendToServer((Object)new SetTarget(this.state, string, UnitOptionsScreen.this.turret.m_19879_()));
            }
        }
    }
}

