/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.arrow;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.arrow.Arrow2;
import dev.buildtool.kturrets.arrow.ArrowDroneContainer;
import dev.buildtool.kturrets.registers.KTEntities;
import dev.buildtool.kturrets.tasks.AttackTargetGoal;
import dev.buildtool.kturrets.tasks.RestrictedRangedAttackGoal;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrowDrone
extends Drone {
    protected final ItemHandler weapon = new ItemHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() instanceof CrossbowItem || stack.m_41720_() instanceof BowItem;
        }
    };
    protected final ItemHandler ammo = new ItemHandler(18){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_204117_(KTurrets.ARROW_UNIT_AMMO_TAG);
        }
    };

    public ArrowDrone(Level world) {
        super((EntityType<? extends PathfinderMob>)((EntityType)KTEntities.ARROW_DRONE.get()), world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new RestrictedRangedAttackGoal(this, 1.0, (Integer)KTurrets.ARROW_TURRET_RATE.get(), (float)this.getRange()));
        this.f_21346_.m_25352_(5, (Goal)new AttackTargetGoal(this));
    }

    @Override
    protected List<ItemHandler> getContainedItems() {
        return Arrays.asList(this.ammo, this.weapon);
    }

    @Override
    public boolean isArmed() {
        return !this.ammo.isEmpty();
    }

    @Override
    public int getDamage() {
        return (Integer)KTurrets.ARROW_TURRET_DAMAGE.get();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            ItemStack weapon = this.weapon.getStackInSlot(0);
            for (ItemStack arrows : this.ammo.getItems()) {
                if (arrows.m_41619_()) continue;
                AbstractArrow arrowEntity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrows, (float)distanceFactor);
                double dx = target.m_20185_() - this.m_20185_();
                double dy = target.m_20188_() - this.m_20188_();
                double dz = target.m_20189_() - this.m_20189_();
                double damage = ((Integer)KTurrets.ARROW_TURRET_DAMAGE.get()).intValue();
                arrowEntity.m_36781_(damage);
                Arrow2 arrow2 = new Arrow2(this.m_9236_(), arrowEntity, this, distanceFactor, (float)dx, (float)dy, (float)dz);
                arrow2.m_36781_(arrowEntity.m_36789_());
                if (weapon.m_41720_() instanceof CrossbowItem) {
                    arrow2.m_36793_(true);
                    int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)weapon);
                    if (i > 0) {
                        arrow2.m_36767_((byte)i);
                    }
                }
                arrow2.m_36745_((LivingEntity)this, distanceFactor);
                arrow2.m_20242_(true);
                arrow2.m_6686_(dx, dy, dz, 1.8f, 0.0f);
                this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
                this.m_9236_().m_7967_((Entity)arrow2);
                arrows.m_41774_(1);
                if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44952_, (LivingEntity)this) != 0 || EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44959_, (LivingEntity)this) != 0) break;
                weapon.m_41622_(1, (LivingEntity)this, turret -> turret.m_21190_(InteractionHand.MAIN_HAND));
                break;
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory inventory, Player p_39956_) {
        FriendlyByteBuf byteBuf = Functions.emptyBuffer();
        byteBuf.writeInt(this.m_19879_());
        return new ArrowDroneContainer(p_39954_, inventory, byteBuf);
    }

    @Override
    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128365_("Ammo", (Tag)this.ammo.serializeNBT());
        compoundNBT.m_128365_("Weapon", (Tag)this.weapon.serializeNBT());
    }

    @Override
    public void m_7378_(CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        this.weapon.deserializeNBT(compoundNBT.m_128469_("Weapon"));
        this.ammo.deserializeNBT(compoundNBT.m_128469_("Ammo"));
    }
}

