/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.brick;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.brick.Brick;
import dev.buildtool.kturrets.brick.BrickDroneContainer;
import dev.buildtool.kturrets.registers.KTEntities;
import dev.buildtool.kturrets.registers.Sounds;
import dev.buildtool.kturrets.tasks.AttackTargetGoal;
import dev.buildtool.kturrets.tasks.RestrictedRangedAttackGoal;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemHandler;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrickDrone
extends Drone {
    protected ItemHandler ammo = new ItemHandler(18){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_204117_(KTurrets.BRICK_UNIT_AMMO_TAG);
        }
    };

    public BrickDrone(Level world) {
        super((EntityType<? extends PathfinderMob>)((EntityType)KTEntities.BRICK_DRONE.get()), world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new RestrictedRangedAttackGoal(this, 1.0, (Integer)KTurrets.BRICK_TURRET_RATE.get(), (float)this.getRange()));
        this.f_21346_.m_25352_(5, (Goal)new AttackTargetGoal(this));
    }

    @Override
    protected List<ItemHandler> getContainedItems() {
        return List.of(this.ammo, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return !this.ammo.isEmpty();
    }

    public void m_6504_(LivingEntity target, float p_33318_) {
        if (target.m_6084_()) {
            for (ItemStack ammoItem : this.ammo.getItems()) {
                if (ammoItem.m_41619_()) continue;
                double xa = target.m_20185_() - this.m_20185_();
                double ya = target.m_20188_() - this.m_20188_();
                double za = target.m_20189_() - this.m_20189_();
                Brick brick = new Brick(this, xa, ya, za, this.m_9236_());
                brick.setDamage((Integer)KTurrets.BRICK_DAMAGE.get());
                this.m_9236_().m_7967_((Entity)brick);
                this.m_5496_((SoundEvent)Sounds.BRICK_SHOT.get(), 0.3f, 1.0f);
                ammoItem.m_41774_(1);
                break;
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        FriendlyByteBuf buffer = Functions.emptyBuffer();
        buffer.writeInt(this.m_19879_());
        return new BrickDroneContainer(p_39954_, p_39955_, buffer);
    }

    @Override
    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128365_("Ammo", (Tag)this.ammo.serializeNBT());
    }

    @Override
    public void m_7378_(CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        this.ammo.deserializeNBT(compoundNBT.m_128469_("Ammo"));
    }

    @Override
    public int getDamage() {
        return (Integer)KTurrets.BRICK_DAMAGE.get();
    }
}

