/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.cobble;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.cobble.CobbleDroneContainer;
import dev.buildtool.kturrets.cobble.Cobblestone;
import dev.buildtool.kturrets.registers.KTEntities;
import dev.buildtool.kturrets.registers.Sounds;
import dev.buildtool.kturrets.tasks.AttackTargetGoal;
import dev.buildtool.kturrets.tasks.RestrictedRangedAttackGoal;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemHandler;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CobbleDrone
extends Drone {
    protected ItemHandler stone = new ItemHandler(18){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_204117_(KTurrets.COBBLE_UNIT_AMMO_TAG);
        }
    };

    public CobbleDrone(Level world) {
        super((EntityType<? extends PathfinderMob>)((EntityType)KTEntities.COBBLE_DRONE.get()), world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new RestrictedRangedAttackGoal(this, 1.0, (Integer)KTurrets.COBBLE_TURRET_RATE.get(), (float)this.getRange()));
        this.f_21346_.m_25352_(5, (Goal)new AttackTargetGoal(this));
    }

    @Override
    protected List<ItemHandler> getContainedItems() {
        return List.of(this.stone, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return !this.stone.isEmpty();
    }

    public void m_6504_(LivingEntity target, float p_33318_) {
        if (target.m_6084_()) {
            for (ItemStack cobblestoneItem : this.stone.getItems()) {
                if (cobblestoneItem.m_41619_()) continue;
                double xa = target.m_20185_() - this.m_20185_();
                double ya = target.m_20188_() - this.m_20188_();
                double za = target.m_20189_() - this.m_20189_();
                Cobblestone cobblestone = new Cobblestone(this, xa, ya, za, this.m_9236_());
                cobblestone.setDamage((Integer)KTurrets.COBBLE_TURRET_DAMAGE.get());
                this.m_9236_().m_7967_((Entity)cobblestone);
                this.m_5496_((SoundEvent)Sounds.COBBLE_SHOT.get(), 1.0f, 1.0f);
                cobblestoneItem.m_41774_(1);
                break;
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        FriendlyByteBuf friendlyByteBuf = Functions.emptyBuffer();
        friendlyByteBuf.writeInt(this.m_19879_());
        return new CobbleDroneContainer(p_39954_, p_39955_, friendlyByteBuf);
    }

    @Override
    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128365_("Ammo", (Tag)this.stone.serializeNBT());
    }

    @Override
    public void m_7378_(CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        this.stone.deserializeNBT(compoundNBT.m_128469_("Ammo"));
    }

    @Override
    public int getDamage() {
        return (Integer)KTurrets.COBBLE_TURRET_DAMAGE.get();
    }
}

