/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.registers;

import com.google.common.collect.ArrayListMultimap;
import dev.buildtool.kturrets.registers.RegisterCapability;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface UnitLimitCapability {
    public int getTurretCount(UUID var1);

    public int getDroneCount(UUID var1);

    public void setTurretCount(UUID var1, int var2);

    public void setDroneCount(UUID var1, int var2);

    public ArrayListMultimap<UUID, Integer> getPlayersToLimits();

    @SubscribeEvent
    public static void registerCapability(RegisterCapabilitiesEvent capabilitiesEvent) {
        capabilitiesEvent.register(Provider.class);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        UnitLimitCapability unitLimitCapability = new Implementation();

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == RegisterCapability.unitCapability) {
                return LazyOptional.of(() -> this.unitLimitCapability).cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            int number = 0;
            for (Map.Entry uuidCollectionEntry : this.unitLimitCapability.getPlayersToLimits().asMap().entrySet()) {
                List collection = (List)uuidCollectionEntry.getValue();
                UUID uuid = (UUID)uuidCollectionEntry.getKey();
                compoundTag.m_128362_("Player #" + number + " UUID", uuid);
                compoundTag.m_128405_("Player " + uuid + " turret count", ((Integer)collection.get(0)).intValue());
                compoundTag.m_128405_("Player " + uuid + " drone count", ((Integer)collection.get(1)).intValue());
                ++number;
            }
            compoundTag.m_128405_("Turret entries", number);
            return compoundTag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            int turretEntries = nbt.m_128451_("Turret entries");
            for (int i = 0; i < turretEntries; ++i) {
                UUID uuid = nbt.m_128342_("Player #" + i + " UUID");
                int turretSlots = nbt.m_128451_("Player " + uuid + " turret count");
                int droneSlots = nbt.m_128451_("Player " + uuid + " drone count");
                this.unitLimitCapability.getPlayersToLimits().put((Object)uuid, (Object)turretSlots);
                this.unitLimitCapability.getPlayersToLimits().put((Object)uuid, (Object)droneSlots);
            }
        }
    }

    public static class Implementation
    implements UnitLimitCapability {
        public ArrayListMultimap<UUID, Integer> limitMap = ArrayListMultimap.create((int)1, (int)2);

        @Override
        public int getTurretCount(UUID player) {
            List list = this.limitMap.get((Object)player);
            if (list.isEmpty()) {
                return 0;
            }
            return (Integer)list.get(0);
        }

        @Override
        public int getDroneCount(UUID player) {
            List list = this.limitMap.get((Object)player);
            if (list.isEmpty()) {
                return 0;
            }
            return (Integer)list.get(1);
        }

        @Override
        public void setTurretCount(UUID player, int count) {
            List list = this.limitMap.get((Object)player);
            if (list.isEmpty()) {
                list.add(count);
                list.add(0);
            } else {
                list.set(0, count);
            }
        }

        @Override
        public void setDroneCount(UUID player, int count) {
            List list = this.limitMap.get((Object)player);
            if (list.isEmpty()) {
                list.add(0);
                list.add(count);
            } else {
                list.set(1, count);
            }
        }

        @Override
        public ArrayListMultimap<UUID, Integer> getPlayersToLimits() {
            return this.limitMap;
        }
    }
}

