/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.storage;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.packets.PickupParticles;
import dev.buildtool.kturrets.registers.KItems;
import dev.buildtool.kturrets.registers.KTEntities;
import dev.buildtool.kturrets.storage.StorageDroneMenu;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemHandler;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageDrone
extends Drone {
    private static final EntityDataAccessor<Boolean> MAGNET_ACTIVE = SynchedEntityData.m_135353_(StorageDrone.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ItemHandler itemHandler = new ItemHandler(27){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return !stack.m_150930_((Item)KItems.STORAGE_DRONE.get());
        }
    };

    public StorageDrone(Level world) {
        super((EntityType<? extends PathfinderMob>)((EntityType)KTEntities.STORAGE_DRONE.get()), world);
    }

    @Override
    protected List<ItemHandler> getContainedItems() {
        return List.of(this.itemHandler, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return false;
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAGNET_ACTIVE, (Object)true);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        byteBuf.writeInt(this.m_19879_());
        return new StorageDroneMenu(p_39954_, p_39955_, byteBuf);
    }

    @Override
    protected InteractionResult m_6071_(Player playerEntity, InteractionHand interactionHand) {
        return super.m_6071_(playerEntity, interactionHand);
    }

    @Override
    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        compoundNBT.m_128379_("Magnet on", this.isMagnetActive());
    }

    @Override
    public void m_7378_(CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        this.itemHandler.deserializeNBT(compoundNBT.m_128469_("Items"));
        this.setMagnetActive(compoundNBT.m_128471_("Magnet on"));
    }

    @Override
    public void m_8119_() {
        ItemStack magnet;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (magnet = Functions.findItem((Item)((Item)KItems.MAGNET_UPGRADE.get()), (IItemHandler)this.upgrades)).m_150930_((Item)KItems.MAGNET_UPGRADE.get()) && this.isMagnetActive()) {
            List itemEntities = this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82400_(32.0));
            itemEntities.forEach(itemEntity -> {
                ItemStack entityItem = itemEntity.m_32055_();
                if (!entityItem.m_150930_((Item)KItems.STORAGE_DRONE.get())) {
                    magnet.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                        if (magnet.m_41784_().m_128471_("Filter")) {
                            for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                                ItemStack item = iItemHandler.getStackInSlot(i);
                                if (!Functions.areItemTypesEqual((ItemStack)item, (ItemStack)entityItem)) continue;
                                ItemStack tryInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)entityItem, (boolean)true);
                                if (!tryInsert.m_41619_()) break;
                                itemEntity.m_32010_(20);
                                itemEntity.m_20256_(this.m_20318_(1.0f).m_82546_(itemEntity.m_20182_()).m_82541_().m_82559_(new Vec3(0.5, 0.5, 0.5)));
                                KTurrets.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 22.0, this.m_9236_().m_46472_())), (Object)new PickupParticles(itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_()));
                                if (this.m_20270_((Entity)itemEntity) < 1.0f && Functions.tryInsertItem((IItemHandler)this.itemHandler, (ItemStack)entityItem)) {
                                    itemEntity.m_146870_();
                                }
                                break;
                            }
                        } else {
                            ItemStack tryInsert;
                            boolean isBlacklisted = false;
                            for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                                ItemStack itemStack = iItemHandler.getStackInSlot(i);
                                if (!Functions.areItemTypesEqual((ItemStack)itemStack, (ItemStack)entityItem)) continue;
                                isBlacklisted = true;
                                break;
                            }
                            if (!isBlacklisted && (tryInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)entityItem, (boolean)true)).m_41619_()) {
                                itemEntity.m_32010_(Functions.secondsToTicks((int)5));
                                itemEntity.m_20256_(this.m_20318_(1.0f).m_82546_(itemEntity.m_20182_()).m_82541_().m_82542_(0.25, 0.25, 0.25));
                                KTurrets.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 22.0, this.m_9236_().m_46472_())), (Object)new PickupParticles(itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_()));
                                if (this.m_20270_((Entity)itemEntity) < 1.0f && Functions.tryInsertItem((IItemHandler)this.itemHandler, (ItemStack)entityItem)) {
                                    itemEntity.m_146870_();
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    public void setMagnetActive(boolean b) {
        this.f_19804_.m_135381_(MAGNET_ACTIVE, (Object)b);
    }

    public boolean isMagnetActive() {
        return (Boolean)this.f_19804_.m_135370_(MAGNET_ACTIVE);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Mob.class, living -> {
            Player owner;
            if (this.getOwner().isPresent() && (owner = this.m_9236_().m_46003_(this.getOwnerUUID())) != null) {
                Mob mob = (Mob)living;
                return mob.m_5448_() == owner;
            }
            return false;
        }, 6.0f, 1.0, 1.0, living -> true));
    }
}

