/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker.impl.recipe.handler.helper.SmithingRecipeConflictChecker;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessSmithingTransformRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;

@IRecipeHandler.For(value=SmithingTransformRecipe.class)
public final class SmithingTransformRecipeHandler
implements IRecipeHandler<SmithingTransformRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super SmithingTransformRecipe> manager, SmithingTransformRecipe recipe) {
        Object[] objectArray = new Object[5];
        objectArray[0] = StringUtil.quoteAndEscape(recipe.m_6423_());
        objectArray[1] = ItemStackUtil.getCommandString(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((SmithingTransformRecipe)recipe).m_8043_(arg_0)));
        objectArray[2] = IIngredient.fromIngredient(((AccessSmithingTransformRecipe)recipe).crafttweaker$getTemplate()).getCommandString();
        objectArray[3] = IIngredient.fromIngredient(((AccessSmithingTransformRecipe)recipe).crafttweaker$getBase()).getCommandString();
        objectArray[4] = IIngredient.fromIngredient(((AccessSmithingTransformRecipe)recipe).crafttweaker$getAddition()).getCommandString();
        return String.format("smithing.addTransformRecipe(%s, %s, %s, %s, %s);", objectArray);
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super SmithingTransformRecipe> manager, SmithingTransformRecipe firstRecipe, U secondRecipe) {
        if (!(secondRecipe instanceof SmithingRecipe)) {
            return false;
        }
        SmithingRecipe secondSmithing = (SmithingRecipe)secondRecipe;
        return SmithingRecipeConflictChecker.doesConflict(manager, (SmithingRecipe)firstRecipe, secondSmithing);
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super SmithingTransformRecipe> manager, SmithingTransformRecipe recipe) {
        AccessSmithingTransformRecipe access = (AccessSmithingTransformRecipe)recipe;
        IIngredient template = IIngredient.fromIngredient(access.crafttweaker$getTemplate());
        IIngredient base = IIngredient.fromIngredient(access.crafttweaker$getBase());
        IIngredient addition = IIngredient.fromIngredient(access.crafttweaker$getAddition());
        IDecomposedRecipe decomposed = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, List.of(template, base, addition)).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((SmithingTransformRecipe)recipe).m_8043_(arg_0)))).build();
        return Optional.of(decomposed);
    }

    @Override
    public Optional<SmithingTransformRecipe> recompose(IRecipeManager<? super SmithingTransformRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        if (ingredients.size() != 3) {
            throw new IllegalArgumentException("Invalid inputs: expected three ingredients for recipe, but got " + ingredients.size() + ": " + ingredients);
        }
        if (ingredients.stream().anyMatch(IIngredient::isEmpty)) {
            throw new IllegalArgumentException("Invalid inputs: empty ingredients");
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid outputs: empty item");
        }
        Ingredient template = ingredients.get(0).asVanillaIngredient();
        Ingredient base = ingredients.get(1).asVanillaIngredient();
        Ingredient addition = ingredients.get(2).asVanillaIngredient();
        return Optional.of(new SmithingTransformRecipe(name, template, base, addition, output.getInternal()));
    }
}

