/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeDataBuilder;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.TreeConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface Tree<T extends TreeConfig> {
    public boolean mineableBlock(BlockState var1);

    public TreeData getTreeData(TreeDataBuilder var1, BlockPos var2, BlockGetter var3);

    default public void entityTick(TreeEntity entity) {
        Level level = entity.m_9236_();
        if (entity.f_19797_ >= entity.getMaxLifeTimeTick()) {
            this.getDrops(entity, entity.getBlocks()).forEach(itemStack -> Block.m_49840_((Level)level, (BlockPos)entity.getOriginPos(), (ItemStack)itemStack));
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    default public boolean willTreeFall(BlockPos blockPos, BlockGetter level, Player player) {
        if (((TreeConfig)this.getConfig()).onlyFallWithRequiredTool && !((TreeConfig)this.getConfig()).allowedToolFilter.isValid(player.m_6844_(EquipmentSlot.MAINHAND))) {
            return false;
        }
        return FallingTreesConfig.getCommonConfig().disableCrouchMining || player.m_6047_() == FallingTreesConfig.getClientConfig((Player)player).invertCrouchMining;
    }

    default public float fallAnimationEdgeDistance() {
        return 1.0f;
    }

    default public boolean enabled() {
        return true;
    }

    default public List<ItemStack> getDrops(TreeEntity entity, Map<BlockPos, BlockState> blocks) {
        Level level = entity.m_9236_();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blocks.forEach((blockPos, blockState) -> {
                BlockEntity blockEntity = null;
                if (blockState.m_155947_()) {
                    blockEntity = serverLevel.m_7702_(blockPos);
                }
                itemStacks.addAll(Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)blockPos, (BlockEntity)blockEntity, (Entity)entity.owner, (ItemStack)entity.getUsedTool()));
            });
        }
        return itemStacks;
    }

    public T getConfig();
}

