/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import net.minecraft.core.BlockPos;
import org.joml.Math;

public class TreeDataBuilder {
    private Set<BlockPos> blocks = new HashSet<BlockPos>();
    private boolean useDefaultMiningSpeed = true;
    private float miningSpeedMultiplication = 1.0f;
    private int toolDamage = 0;
    private float foodExhaustionMultiplication = 1.0f;
    private int awardedBlocks = 0;

    public Set<BlockPos> getBlocks() {
        return this.blocks;
    }

    public TreeDataBuilder setBlocks(Set<BlockPos> blocks) {
        this.blocks = blocks;
        return this;
    }

    public TreeDataBuilder setMiningSpeed(float multiply) {
        this.useDefaultMiningSpeed = false;
        this.miningSpeedMultiplication = multiply;
        return this;
    }

    public TreeDataBuilder addBlocks(Collection<BlockPos> blocks) {
        this.blocks.addAll(blocks);
        return this;
    }

    public TreeDataBuilder addBlock(BlockPos blockPos) {
        this.blocks.add(blockPos);
        return this;
    }

    public TreeDataBuilder setToolDamage(int toolDamage) {
        this.toolDamage = toolDamage;
        return this;
    }

    public TreeDataBuilder setFoodExhaustion(float multiply) {
        this.foodExhaustionMultiplication = multiply;
        return this;
    }

    public TreeDataBuilder setAwardedBlocks(int awardedBlocks) {
        this.awardedBlocks = awardedBlocks;
        return this;
    }

    public TreeData build(boolean shouldFall) {
        return new TreeData(this.blocks, this.useDefaultMiningSpeed ? this.getDefaultMiningSpeed() : this.miningSpeedMultiplication, shouldFall, this.toolDamage, this.foodExhaustionMultiplication, this.awardedBlocks);
    }

    protected float getDefaultMiningSpeed() {
        float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
        float multiplyAmount = Math.min((float)FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)((float)this.blocks.size() - 1.0f));
        return 1.0f / (multiplyAmount * speedMultiplication + 1.0f);
    }
}

