/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.pandamods.fallingtrees.api.Tree;
import me.pandamods.fallingtrees.api.TreeRegistry;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.registry.EntityRegistry;
import me.pandamods.fallingtrees.utils.BlockMapEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class TreeEntity
extends Entity {
    public static final EntityDataAccessor<Map<BlockPos, BlockState>> BLOCKS = SynchedEntityData.m_135353_(TreeEntity.class, BlockMapEntityData.BLOCK_MAP);
    public static final EntityDataAccessor<Integer> HEIGHT = SynchedEntityData.m_135353_(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<BlockPos> ORIGIN_POS = SynchedEntityData.m_135353_(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<ItemStack> USED_TOOL = SynchedEntityData.m_135353_(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Direction> FALL_DIRECTION = SynchedEntityData.m_135353_(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    public static final EntityDataAccessor<String> TREE_TYPE_LOCATION = SynchedEntityData.m_135353_(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public Entity owner = null;
    public Tree<?> tree = null;

    public TreeEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
    }

    public static void destroyTree(Set<BlockPos> blockPosList, BlockPos blockPos, LevelAccessor levelAccessor, Tree<?> tree, Player player) {
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            TreeEntity treeEntity = new TreeEntity((EntityType)EntityRegistry.TREE.get(), (Level)level);
            treeEntity.m_146884_(blockPos.m_252807_().m_82520_(0.0, -0.5, 0.0));
            treeEntity.setData(blockPosList, blockPos, tree, (Entity)player, player.m_6844_(EquipmentSlot.MAINHAND));
            BlockState air = Blocks.f_50016_.m_49966_();
            for (BlockPos blockPos2 : blockPosList) {
                BlockState oldState = level.m_8055_(blockPos2);
                level.m_7731_(blockPos2, air, 16);
                level.m_6550_(blockPos2, oldState, level.m_8055_(blockPos2));
            }
            for (Map.Entry entry : treeEntity.getBlocks().entrySet()) {
                BlockPos pos = ((BlockPos)entry.getKey()).m_121955_((Vec3i)blockPos);
                BlockState newState = level.m_8055_(pos);
                level.m_7260_(pos, (BlockState)entry.getValue(), newState, 3);
                level.m_6289_(pos, newState.m_60734_());
                newState.m_60758_((LevelAccessor)level, pos, 511);
                ((BlockState)entry.getValue()).m_60701_((LevelAccessor)level, pos, 511);
                ((BlockState)entry.getValue()).m_60758_((LevelAccessor)level, pos, 511);
                level.m_6559_(pos, (BlockState)entry.getValue(), newState);
            }
            level.m_7967_((Entity)treeEntity);
        }
    }

    public void setData(Set<BlockPos> blockPosList, BlockPos originBlock, Tree<?> tree, Entity owner, ItemStack itemStack) {
        this.owner = owner;
        this.tree = tree;
        int height = 0;
        Level level = this.m_9236_();
        HashMap<BlockPos, BlockState> blockPosMap = new HashMap<BlockPos, BlockState>();
        for (BlockPos pos : blockPosList) {
            if (pos.m_123342_() > height) {
                height = pos.m_123342_() - originBlock.m_123342_();
            }
            blockPosMap.put(pos.m_7949_().m_121996_((Vec3i)originBlock), level.m_8055_(pos));
        }
        this.m_20088_().m_135381_(ORIGIN_POS, (Object)originBlock);
        this.m_20088_().m_135381_(BLOCKS, blockPosMap);
        this.m_20088_().m_135381_(HEIGHT, (Object)height);
        this.m_20088_().m_135381_(USED_TOOL, (Object)itemStack);
        ResourceLocation treeTypeLocation = TreeRegistry.getTreeLocation(tree);
        if (treeTypeLocation != null) {
            this.m_20088_().m_135381_(TREE_TYPE_LOCATION, (Object)treeTypeLocation.toString());
        }
        this.m_20088_().m_135381_(FALL_DIRECTION, (Object)Direction.m_122364_((double)(-Math.toDegrees((double)Math.atan2((double)(owner.m_20185_() - (double)originBlock.m_123341_()), (double)(owner.m_20189_() - (double)originBlock.m_123343_()))))).m_122424_());
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(BLOCKS, new HashMap());
        this.m_20088_().m_135372_(HEIGHT, (Object)0);
        this.m_20088_().m_135372_(ORIGIN_POS, (Object)new BlockPos(0, 0, 0));
        this.m_20088_().m_135372_(USED_TOOL, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(FALL_DIRECTION, (Object)Direction.NORTH);
        this.m_20088_().m_135372_(TREE_TYPE_LOCATION, (Object)"");
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.5, 1.0));
        }
        this.getTree().entityTick(this);
    }

    public Map<BlockPos, BlockState> getBlocks() {
        return (Map)this.m_20088_().m_135370_(BLOCKS);
    }

    public int getMaxLifeTimeTick() {
        return (int)(FallingTreesConfig.getCommonConfig().treeLifetimeLength * 20.0f);
    }

    public float getLifetime(float partialTick) {
        return ((float)this.f_19797_ + partialTick) / 20.0f;
    }

    public float getHeight() {
        return ((Integer)this.m_20088_().m_135370_(HEIGHT)).intValue();
    }

    public BlockPos getOriginPos() {
        return (BlockPos)this.m_20088_().m_135370_(ORIGIN_POS);
    }

    public ItemStack getUsedTool() {
        return (ItemStack)this.m_20088_().m_135370_(USED_TOOL);
    }

    @NotNull
    public Direction m_6350_() {
        return (Direction)this.m_20088_().m_135370_(FALL_DIRECTION);
    }

    public Tree<?> getTree() {
        Optional<Tree<?>> treeTypeOptional = TreeRegistry.getTree(ResourceLocation.m_135820_((String)((String)this.m_20088_().m_135370_(TREE_TYPE_LOCATION))));
        return treeTypeOptional.orElse(null);
    }
}

