/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.utils.value.IntValue;
import java.util.Optional;
import java.util.Set;
import me.pandamods.fallingtrees.api.Tree;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeDataBuilder;
import me.pandamods.fallingtrees.api.TreeRegistry;
import me.pandamods.fallingtrees.compat.TreeChopCompat;
import me.pandamods.fallingtrees.config.CommonConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class EventHandler {
    public static void register() {
        BlockEvent.BREAK.register(EventHandler::onBlockBreak);
    }

    private static EventResult onBlockBreak(Level level, BlockPos blockPos, BlockState blockState, ServerPlayer serverPlayer, IntValue intValue) {
        if (serverPlayer != null && !TreeChopCompat.isChoppable(level, blockPos) && EventHandler.makeTreeFall(blockPos, (LevelAccessor)level, (Player)serverPlayer)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static boolean makeTreeFall(BlockPos blockPos, LevelAccessor level, Player player) {
        if (level.m_5776_()) {
            return false;
        }
        Optional<Tree<?>> treeTypeOptional = TreeRegistry.getTree(level.m_8055_(blockPos));
        return treeTypeOptional.filter(treeType -> EventHandler.makeTreeFall(treeType, blockPos, level, player)).isPresent();
    }

    public static boolean makeTreeFall(Tree<?> tree, BlockPos blockPos, LevelAccessor level, Player player) {
        if (level.m_5776_()) {
            return false;
        }
        BlockState blockState = level.m_8055_(blockPos);
        CommonConfig commonConfig = FallingTreesConfig.getCommonConfig();
        if (!tree.willTreeFall(blockPos, (BlockGetter)level, player)) {
            return false;
        }
        ItemStack mainItem = player.m_6844_(EquipmentSlot.MAINHAND);
        TreeData treeData = tree.getTreeData(new TreeDataBuilder(), blockPos, (BlockGetter)level);
        Set<BlockPos> treeBlockPos = treeData.blocks();
        if (!treeData.shouldFall()) {
            return false;
        }
        if (!mainItem.m_41619_()) {
            mainItem.m_41622_(commonConfig.disableExtraToolDamage ? 1 : treeData.toolDamage(), (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        float defaultExhaustion = 0.005f;
        player.m_36399_(commonConfig.disableExtraFoodExhaustion ? defaultExhaustion : defaultExhaustion * treeData.foodExhaustionMultiply());
        player.m_6278_(Stats.f_12949_.m_12902_((Object)blockState.m_60734_()), treeData.awardedBlocks());
        TreeEntity.destroyTree(treeBlockPos, blockPos, level, tree, player);
        return true;
    }
}

