/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.mixin;

import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeDataBuilder;
import me.pandamods.fallingtrees.api.TreeRegistry;
import me.pandamods.fallingtrees.compat.Compat;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.utils.TreeCache;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateMixin {
    @Inject(method={"getDestroyProgress"}, at={@At(value="RETURN")}, cancellable=true)
    public void getDestroyProgress(Player player, BlockGetter level, BlockPos pos, CallbackInfoReturnable<Float> cir) {
        if (FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.disable || Compat.hasTreeChop()) {
            return;
        }
        TreeRegistry.getTree(level.m_8055_(pos)).ifPresent(tree -> {
            if (!tree.willTreeFall(pos, level, player)) {
                return;
            }
            TreeData treeData = TreeCache.get(player, pos, () -> tree.getTreeData(new TreeDataBuilder(), pos, level));
            cir.setReturnValue((Object)Float.valueOf(cir.getReturnValueF() * treeData.miningSpeedMultiply()));
        });
    }
}

