/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.pandamods.fallingtrees.api.Tree;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeDataBuilder;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.TreeConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.utils.ListUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChorusTree
implements Tree<TreeConfig> {
    @Override
    public boolean mineableBlock(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_50490_);
    }

    public boolean extraRequiredBlockCheck(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_50491_);
    }

    @Override
    public TreeData getTreeData(TreeDataBuilder builder, BlockPos blockPos, BlockGetter level) {
        HashSet<BlockPos> loopedBlocks = new HashSet<BlockPos>();
        this.loopBlocks(level, blockPos, builder, loopedBlocks);
        return builder.setAwardedBlocks(builder.getBlocks().size()).setFoodExhaustion(builder.getBlocks().size()).setToolDamage(builder.getBlocks().size()).build(true);
    }

    public void loopBlocks(BlockGetter level, BlockPos originPos, TreeDataBuilder builder, Set<BlockPos> loopedBlocks) {
        if (loopedBlocks.contains(originPos)) {
            return;
        }
        loopedBlocks.add(originPos);
        BlockState blockState = level.m_8055_(originPos);
        if (this.mineableBlock(blockState) || this.extraRequiredBlockCheck(blockState)) {
            builder.addBlock(originPos);
            if (this.mineableBlock(blockState)) {
                for (Direction direction : Direction.values()) {
                    if (!((Boolean)blockState.m_61143_((Property)ChorusPlantBlock.f_55154_.get(direction))).booleanValue()) continue;
                    BlockPos neighborPos = originPos.m_121955_(direction.m_122436_());
                    this.loopBlocks(level, neighborPos, builder, loopedBlocks);
                }
            }
        }
    }

    @Override
    public float fallAnimationEdgeDistance() {
        return 0.375f;
    }

    @Override
    public TreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.chorusTree;
    }

    @Override
    public boolean enabled() {
        return this.getConfig().enabled;
    }

    @Override
    public List<ItemStack> getDrops(TreeEntity entity, Map<BlockPos, BlockState> blocks) {
        return Tree.super.getDrops(entity, ListUtils.mapRemoveIf(blocks, (blockPos, blockState) -> blockState.m_60713_(Blocks.f_50491_)));
    }
}

