/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import java.util.HashSet;
import java.util.Set;
import me.pandamods.fallingtrees.api.Tree;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeDataBuilder;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.MushroomTreeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Math;

public class MushroomTree
implements Tree<MushroomTreeConfig> {
    @Override
    public boolean mineableBlock(BlockState blockState) {
        return this.getConfig().stemFilter.isValid(blockState);
    }

    @Override
    public TreeData getTreeData(TreeDataBuilder builder, BlockPos blockPos, BlockGetter level) {
        if (!this.mineableBlock(level.m_8055_(blockPos.m_7494_()))) {
            return builder.build(false);
        }
        HashSet<BlockPos> stemBlocks = new HashSet<BlockPos>();
        HashSet capBlocks = new HashSet();
        HashSet<BlockPos> loopedStemBlocks = new HashSet<BlockPos>();
        this.loopStems(level, blockPos, stemBlocks, loopedStemBlocks);
        float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
        float multiplyAmount = Math.min((float)FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)((float)stemBlocks.size() - 1.0f));
        builder.setMiningSpeed(1.0f / (multiplyAmount * speedMultiplication + 1.0f));
        stemBlocks.forEach(logPos -> {
            HashSet<BlockPos> loopedCapBlocks = new HashSet<BlockPos>();
            for (BlockPos offset : BlockPos.m_121940_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1))) {
                BlockPos neighborPos = logPos.m_121955_((Vec3i)offset);
                this.loopCap(level, neighborPos, capBlocks, loopedCapBlocks);
            }
        });
        if (capBlocks.isEmpty()) {
            return builder.build(false);
        }
        HashSet<BlockPos> treeBlocks = new HashSet<BlockPos>();
        treeBlocks.addAll(stemBlocks);
        treeBlocks.addAll(capBlocks);
        return builder.addBlocks(treeBlocks).setAwardedBlocks(stemBlocks.size()).setFoodExhaustion(stemBlocks.size()).setToolDamage(stemBlocks.size()).build(true);
    }

    public void loopStems(BlockGetter level, BlockPos blockPos, Set<BlockPos> blocks, Set<BlockPos> loopedBlocks) {
        if (loopedBlocks.contains(blockPos)) {
            return;
        }
        loopedBlocks.add(blockPos);
        BlockState blockState = level.m_8055_(blockPos);
        if (this.mineableBlock(blockState)) {
            blocks.add(blockPos);
            for (BlockPos offset : BlockPos.m_121940_((BlockPos)new BlockPos(-1, 0, -1), (BlockPos)new BlockPos(1, 1, 1))) {
                BlockPos neighborPos = blockPos.m_121955_((Vec3i)offset);
                this.loopStems(level, neighborPos, blocks, loopedBlocks);
            }
        }
    }

    public void loopCap(BlockGetter level, BlockPos blockPos, Set<BlockPos> blocks, Set<BlockPos> loopedBlocks) {
        if (loopedBlocks.contains(blockPos)) {
            return;
        }
        loopedBlocks.add(blockPos);
        BlockState blockState = level.m_8055_(blockPos);
        if (this.getConfig().capFilter.isValid(blockState)) {
            blocks.add(blockPos);
            for (BlockPos offset : BlockPos.m_121940_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1))) {
                BlockPos neighborPos = blockPos.m_121955_((Vec3i)offset);
                this.loopCap(level, neighborPos, blocks, loopedBlocks);
            }
        }
    }

    @Override
    public MushroomTreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.mushroomTree;
    }

    @Override
    public boolean enabled() {
        return this.getConfig().enabled;
    }
}

