/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import dev.architectury.platform.Platform;
import java.util.HashSet;
import java.util.Set;
import me.pandamods.fallingtrees.api.Tree;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeDataBuilder;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.StandardTreeConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.registry.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import org.joml.Math;

public class StandardTree
implements Tree<StandardTreeConfig> {
    @Override
    public boolean mineableBlock(BlockState blockState) {
        return FallingTreesConfig.getCommonConfig().trees.standardTree.logFilter.isValid(blockState);
    }

    public boolean extraRequiredBlockCheck(BlockState blockState) {
        if (this.getConfig().algorithm.shouldIgnorePersistentLeaves && blockState.m_61138_((Property)BlockStateProperties.f_61447_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61447_)).booleanValue()) {
            return false;
        }
        return FallingTreesConfig.getCommonConfig().trees.standardTree.leavesFilter.isValid(blockState);
    }

    @Override
    public void entityTick(TreeEntity entity) {
        Tree.super.entityTick(entity);
        Level level = entity.m_9236_();
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientConfig clientConfig = FallingTreesConfig.getClientConfig();
            if (entity.f_19797_ == 1 && clientConfig.soundSettings.enabled) {
                level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)SoundRegistry.TREE_FALL.get(), SoundSource.BLOCKS, clientConfig.soundSettings.startVolume, 1.0f, true);
            }
            if (entity.f_19797_ == (int)(clientConfig.animation.fallAnimLength * 20.0f) - 5 && clientConfig.soundSettings.enabled) {
                level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)SoundRegistry.TREE_IMPACT.get(), SoundSource.BLOCKS, clientConfig.soundSettings.endVolume, 1.0f, true);
            }
        }
    }

    @Override
    public TreeData getTreeData(TreeDataBuilder builder, BlockPos blockPos, BlockGetter level) {
        if (!this.mineableBlock(level.m_8055_(blockPos.m_7494_()))) {
            return builder.build(false);
        }
        HashSet<BlockPos> logBlocks = new HashSet<BlockPos>();
        HashSet leavesBlocks = new HashSet();
        HashSet<BlockPos> decorationBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> loopedLogBlocks = new HashSet<BlockPos>();
        HashSet loopedDecorationBlocks = new HashSet();
        this.loopLogs(level, blockPos, logBlocks, loopedLogBlocks);
        if (!this.getConfig().algorithm.shouldFallOnMaxLogAmount && this.isMaxAmountReached(logBlocks.size())) {
            return builder.build(false);
        }
        float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
        float multiplyAmount = Math.min((float)FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)((float)logBlocks.size() - 1.0f));
        builder.setMiningSpeed(1.0f / (multiplyAmount * speedMultiplication + 1.0f));
        logBlocks.forEach(logPos -> {
            HashSet<BlockPos> loopedLeavesBlocks = new HashSet<BlockPos>();
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = logPos.m_121955_(direction.m_122436_());
                this.loopLeaves(level, neighborPos, leavesBlocks, loopedLeavesBlocks, 1);
            }
        });
        if (leavesBlocks.isEmpty()) {
            return builder.build(false);
        }
        HashSet<BlockPos> treeBlocks = new HashSet<BlockPos>();
        treeBlocks.addAll(logBlocks);
        treeBlocks.addAll(leavesBlocks);
        treeBlocks.forEach(pos -> {
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.m_121955_(direction.m_122436_());
                this.loopExtraBlocks(level, neighborPos, decorationBlocks, loopedDecorationBlocks);
            }
        });
        return builder.addBlocks(treeBlocks).addBlocks(decorationBlocks).setAwardedBlocks(logBlocks.size()).setFoodExhaustion(logBlocks.size()).setToolDamage(logBlocks.size()).build(true);
    }

    public void loopLogs(BlockGetter level, BlockPos blockPos, Set<BlockPos> blocks, Set<BlockPos> loopedBlocks) {
        if (loopedBlocks.contains(blockPos)) {
            return;
        }
        if (this.isMaxAmountReached(blocks.size())) {
            return;
        }
        loopedBlocks.add(blockPos);
        BlockState blockState = level.m_8055_(blockPos);
        if (this.mineableBlock(blockState)) {
            blocks.add(blockPos);
            for (BlockPos offset : BlockPos.m_121940_((BlockPos)new BlockPos(-1, 0, -1), (BlockPos)new BlockPos(1, 1, 1))) {
                BlockPos neighborPos = blockPos.m_121955_((Vec3i)offset);
                this.loopLogs(level, neighborPos, blocks, loopedBlocks);
            }
        }
    }

    public void loopLeaves(BlockGetter level, BlockPos blockPos, Set<BlockPos> blocks, Set<BlockPos> loopedBlocks, int recursionDistance) {
        if (recursionDistance > this.getConfig().algorithm.maxLeavesRadius) {
            return;
        }
        BlockState blockState = level.m_8055_(blockPos);
        if (loopedBlocks.contains(blockPos) || blockState.m_61138_((Property)LeavesBlock.f_54418_) && (Integer)blockState.m_61143_((Property)LeavesBlock.f_54418_) != recursionDistance) {
            return;
        }
        loopedBlocks.add(blockPos);
        if (this.extraRequiredBlockCheck(blockState)) {
            blocks.add(blockPos);
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = blockPos.m_121955_(direction.m_122436_());
                this.loopLeaves(level, neighborPos, blocks, loopedBlocks, recursionDistance + 1);
            }
        }
    }

    public void loopExtraBlocks(BlockGetter level, BlockPos blockPos, Set<BlockPos> blocks, Set<BlockPos> loopedBlocks) {
        BlockState blockState = level.m_8055_(blockPos);
        if (loopedBlocks.contains(blockPos)) {
            return;
        }
        loopedBlocks.add(blockPos);
        if (this.getConfig().extraBlockFilter.isValid(blockState)) {
            blocks.add(blockPos);
            this.loopExtraBlocks(level, blockPos.m_121955_(Direction.DOWN.m_122436_()), blocks, loopedBlocks);
        }
    }

    @Override
    public StandardTreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.standardTree;
    }

    public boolean isMaxAmountReached(int amount) {
        return amount >= this.getConfig().algorithm.maxLogAmount;
    }

    @Override
    public boolean enabled() {
        return FallingTreesConfig.getCommonConfig().trees.standardTree.enabled;
    }
}

