/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import me.pandamods.assimp.AIMetaDataEntry;
import me.pandamods.assimp.AIString;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMetadata")
public class AIMetaData
extends Struct<AIMetaData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNUMPROPERTIES;
    public static final int MKEYS;
    public static final int MVALUES;

    protected AIMetaData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIMetaData create(long address, @Nullable ByteBuffer container) {
        return new AIMetaData(address, container);
    }

    public AIMetaData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIMetaData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mNumProperties() {
        return AIMetaData.nmNumProperties(this.address());
    }

    @NativeType(value="struct aiString *")
    public AIString.Buffer mKeys() {
        return AIMetaData.nmKeys(this.address());
    }

    @NativeType(value="struct aiMetadataEntry *")
    public AIMetaDataEntry.Buffer mValues() {
        return AIMetaData.nmValues(this.address());
    }

    public AIMetaData mNumProperties(@NativeType(value="unsigned int") int value) {
        AIMetaData.nmNumProperties(this.address(), value);
        return this;
    }

    public AIMetaData mKeys(@NativeType(value="struct aiString *") AIString.Buffer value) {
        AIMetaData.nmKeys(this.address(), value);
        return this;
    }

    public AIMetaData mValues(@NativeType(value="struct aiMetadataEntry *") AIMetaDataEntry.Buffer value) {
        AIMetaData.nmValues(this.address(), value);
        return this;
    }

    public AIMetaData set(int mNumProperties, AIString.Buffer mKeys, AIMetaDataEntry.Buffer mValues) {
        this.mNumProperties(mNumProperties);
        this.mKeys(mKeys);
        this.mValues(mValues);
        return this;
    }

    public AIMetaData set(AIMetaData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIMetaData malloc() {
        return new AIMetaData(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIMetaData calloc() {
        return new AIMetaData(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIMetaData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIMetaData(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIMetaData create(long address) {
        return new AIMetaData(address, null);
    }

    @Nullable
    public static AIMetaData createSafe(long address) {
        return address == 0L ? null : new AIMetaData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIMetaData.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMetaData.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIMetaData mallocStack() {
        return AIMetaData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMetaData callocStack() {
        return AIMetaData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMetaData mallocStack(MemoryStack stack) {
        return AIMetaData.malloc(stack);
    }

    @Deprecated
    public static AIMetaData callocStack(MemoryStack stack) {
        return AIMetaData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIMetaData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIMetaData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMetaData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMetaData.calloc(capacity, stack);
    }

    public static AIMetaData malloc(MemoryStack stack) {
        return new AIMetaData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIMetaData calloc(MemoryStack stack) {
        return new AIMetaData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmNumProperties(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMPROPERTIES);
    }

    public static AIString.Buffer nmKeys(long struct) {
        return AIString.create(MemoryUtil.memGetAddress((long)(struct + (long)MKEYS)), AIMetaData.nmNumProperties(struct));
    }

    public static AIMetaDataEntry.Buffer nmValues(long struct) {
        return AIMetaDataEntry.create(MemoryUtil.memGetAddress((long)(struct + (long)MVALUES)), AIMetaData.nmNumProperties(struct));
    }

    public static void nmNumProperties(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMPROPERTIES, value);
    }

    public static void nmKeys(long struct, AIString.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MKEYS), (long)value.address());
    }

    public static void nmValues(long struct, AIMetaDataEntry.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MVALUES), (long)value.address());
    }

    public static void validate(long struct) {
        int mNumProperties = AIMetaData.nmNumProperties(struct);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MKEYS)));
        long mValues = MemoryUtil.memGetAddress((long)(struct + (long)MVALUES));
        Checks.check((long)mValues);
        AIMetaData.validate((long)mValues, (int)mNumProperties, (int)AIMetaDataEntry.SIZEOF, AIMetaDataEntry::validate);
    }

    static {
        Struct.Layout layout = AIMetaData.__struct((Struct.Member[])new Struct.Member[]{AIMetaData.__member((int)4), AIMetaData.__member((int)POINTER_SIZE), AIMetaData.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNUMPROPERTIES = layout.offsetof(0);
        MKEYS = layout.offsetof(1);
        MVALUES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIMetaData, Buffer>
    implements NativeResource {
        private static final AIMetaData ELEMENT_FACTORY = AIMetaData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIMetaData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int mNumProperties() {
            return AIMetaData.nmNumProperties(this.address());
        }

        @NativeType(value="struct aiString *")
        public AIString.Buffer mKeys() {
            return AIMetaData.nmKeys(this.address());
        }

        @NativeType(value="struct aiMetadataEntry *")
        public AIMetaDataEntry.Buffer mValues() {
            return AIMetaData.nmValues(this.address());
        }

        public Buffer mNumProperties(@NativeType(value="unsigned int") int value) {
            AIMetaData.nmNumProperties(this.address(), value);
            return this;
        }

        public Buffer mKeys(@NativeType(value="struct aiString *") AIString.Buffer value) {
            AIMetaData.nmKeys(this.address(), value);
            return this;
        }

        public Buffer mValues(@NativeType(value="struct aiMetadataEntry *") AIMetaDataEntry.Buffer value) {
            AIMetaData.nmValues(this.address(), value);
            return this;
        }
    }
}

