/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.pandamods.assimp.AIString;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiSkeleton")
public class AISkeleton
extends Struct<AISkeleton>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MNUMBONES;
    public static final int MBONES;

    protected AISkeleton(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AISkeleton create(long address, @Nullable ByteBuffer container) {
        return new AISkeleton(address, container);
    }

    public AISkeleton(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AISkeleton.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AISkeleton.nmName(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumBones() {
        return AISkeleton.nmNumBones(this.address());
    }

    @NativeType(value="struct aiSkeletonBone **")
    public PointerBuffer mBones() {
        return AISkeleton.nmBones(this.address());
    }

    public AISkeleton mName(@NativeType(value="struct aiString") AIString value) {
        AISkeleton.nmName(this.address(), value);
        return this;
    }

    public AISkeleton mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AISkeleton mBones(@NativeType(value="struct aiSkeletonBone **") PointerBuffer value) {
        AISkeleton.nmBones(this.address(), value);
        return this;
    }

    public AISkeleton set(AIString mName, PointerBuffer mBones) {
        this.mName(mName);
        this.mBones(mBones);
        return this;
    }

    public AISkeleton set(AISkeleton src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AISkeleton malloc() {
        return new AISkeleton(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AISkeleton calloc() {
        return new AISkeleton(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AISkeleton create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AISkeleton(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AISkeleton create(long address) {
        return new AISkeleton(address, null);
    }

    @Nullable
    public static AISkeleton createSafe(long address) {
        return address == 0L ? null : new AISkeleton(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AISkeleton.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AISkeleton.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static AISkeleton malloc(MemoryStack stack) {
        return new AISkeleton(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AISkeleton calloc(MemoryStack stack) {
        return new AISkeleton(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumBones(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMBONES);
    }

    public static PointerBuffer nmBones(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MBONES)), (int)AISkeleton.nmNumBones(struct));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (long)AIString.SIZEOF);
    }

    public static void nmNumBones(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMBONES, value);
    }

    public static void nmBones(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MBONES), (long)MemoryUtil.memAddress((CustomBuffer)value));
        AISkeleton.nmNumBones(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MBONES)));
    }

    static {
        Struct.Layout layout = AISkeleton.__struct((Struct.Member[])new Struct.Member[]{AISkeleton.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AISkeleton.__member((int)4), AISkeleton.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MNUMBONES = layout.offsetof(1);
        MBONES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AISkeleton, Buffer>
    implements NativeResource {
        private static final AISkeleton ELEMENT_FACTORY = AISkeleton.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AISkeleton getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AISkeleton.nmName(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumBones() {
            return AISkeleton.nmNumBones(this.address());
        }

        @NativeType(value="struct aiSkeletonBone **")
        public PointerBuffer mBones() {
            return AISkeleton.nmBones(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AISkeleton.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mBones(@NativeType(value="struct aiSkeletonBone **") PointerBuffer value) {
            AISkeleton.nmBones(this.address(), value);
            return this;
        }
    }
}

