/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.pandamods.pandalib.api.config.Config;
import me.pandamods.pandalib.api.config.ConfigData;
import me.pandamods.pandalib.api.config.holders.ClientConfigHolder;
import me.pandamods.pandalib.api.config.holders.CommonConfigHolder;
import me.pandamods.pandalib.api.config.holders.ConfigHolder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class PandaLibConfig {
    public static Map<Class<? extends ConfigData>, ConfigHolder<? extends ConfigData>> holders = new HashMap<Class<? extends ConfigData>, ConfigHolder<? extends ConfigData>>();

    public static <T extends ConfigData, E extends ConfigHolder<T>> E register(Class<T> configClass, ConfigHolderProvider<T, E> provider) {
        if (holders.containsKey(configClass)) {
            throw new RuntimeException(String.format("Config %s is already registered", configClass));
        }
        Config config = configClass.getAnnotation(Config.class);
        if (config == null) {
            throw new RuntimeException(String.format("%s is not annotated with @Config", configClass));
        }
        E holder = provider.provide(configClass, config);
        holders.put((Class<? extends ConfigData>)configClass, (ConfigHolder<? extends ConfigData>)holder);
        return holder;
    }

    public static <T extends ConfigData> ClientConfigHolder<T> registerClient(Class<T> configClass) {
        return PandaLibConfig.register(configClass, ClientConfigHolder::new);
    }

    public static <T extends ConfigData> CommonConfigHolder<T> registerCommon(Class<T> configClass) {
        return PandaLibConfig.register(configClass, CommonConfigHolder::new);
    }

    public static Optional<ConfigHolder<? extends ConfigData>> getConfig(ResourceLocation resourceLocation) {
        return holders.values().stream().filter(configHolder -> configHolder.resourceLocation().equals((Object)resourceLocation)).findFirst();
    }

    public static Map<Class<? extends ConfigData>, ConfigHolder<? extends ConfigData>> getConfigs() {
        return holders;
    }

    public static <T extends ConfigData> ConfigHolder<T> getConfig(Class<T> config) {
        return holders.get(config);
    }

    public static Map<Class<?>, ConfigHolder<?>> getConfigs(String modId) {
        return holders.entrySet().stream().filter(entry -> ((ConfigHolder)entry.getValue()).getDefinition().modId().equals(modId)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Deprecated
    public static Screen getConfigScreen(String modID) {
        return null;
    }

    @Deprecated
    public static Screen getConfigScreen(Screen parent, String modID) {
        return null;
    }

    @Deprecated
    public static <T extends ConfigData> Screen getConfigScreen(Class<T> configClass) {
        return null;
    }

    @Deprecated
    public static <T extends ConfigData> Screen getConfigScreen(Screen parent, Class<T> configClass) {
        return null;
    }

    public static interface ConfigHolderProvider<T extends ConfigData, E extends ConfigHolder<T>> {
        public E provide(Class<T> var1, Config var2);
    }
}

