/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.config.holders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.pandamods.pandalib.api.config.Config;
import me.pandamods.pandalib.api.config.ConfigData;
import me.pandamods.pandalib.utils.ClassUtils;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHolder<T extends ConfigData> {
    public final Logger logger;
    private final Gson gson;
    private final Class<T> configClass;
    private final Config definition;
    private final ResourceLocation resourceLocation;
    private final boolean synchronize;
    private T config;

    public ConfigHolder(Class<T> configClass, Config config) {
        this.configClass = configClass;
        this.definition = config;
        this.logger = LoggerFactory.getLogger((String)(config.modId() + " | Config"));
        this.gson = this.getNewDefault().buildGson(new GsonBuilder()).setPrettyPrinting().create();
        this.resourceLocation = new ResourceLocation(config.modId(), config.name());
        this.synchronize = config.synchronize();
        if (this.load()) {
            this.save();
        }
    }

    public Gson getGson() {
        return this.gson;
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public Config getDefinition() {
        return this.definition;
    }

    public boolean shouldSynchronize() {
        return this.synchronize;
    }

    public Path getConfigPath() {
        Path path = Platform.getConfigFolder();
        if (!this.definition.parentDirectory().isBlank()) {
            path = path.resolve(this.definition.parentDirectory());
        }
        return path.resolve(this.definition.name() + ".json");
    }

    public void save() {
        JsonObject jsonObject = this.getGson().toJsonTree(this.config).getAsJsonObject();
        this.config.onSave(this, jsonObject);
        Path configPath = this.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            this.getGson().toJson((JsonElement)jsonObject, (Appendable)writer);
            writer.close();
            this.logger.info("Successfully saved config '{}'", (Object)this.definition.name());
        }
        catch (IOException e) {
            this.logger.info("Failed to save config '{}'", (Object)this.definition.name());
            throw new RuntimeException(e);
        }
    }

    public boolean load() {
        block9: {
            Path configPath = this.getConfigPath();
            if (Files.exists(configPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(configPath);){
                    JsonObject jsonObject = (JsonObject)this.getGson().fromJson((Reader)reader, JsonObject.class);
                    this.config = (ConfigData)this.getGson().fromJson((JsonElement)jsonObject, this.configClass);
                    this.config.onLoad(this, jsonObject);
                    break block9;
                }
                catch (IOException e) {
                    this.logger.error("Failed to load config '{}', using default", (Object)this.definition.name(), (Object)e);
                    this.resetToDefault();
                    return false;
                }
            }
            this.resetToDefault();
            this.save();
        }
        this.logger.info("Successfully loaded config '{}'", (Object)this.definition.name());
        return true;
    }

    public void resetToDefault() {
        this.config = this.getNewDefault();
    }

    public T getNewDefault() {
        return (T)((ConfigData)ClassUtils.constructUnsafely(this.configClass));
    }

    public ResourceLocation resourceLocation() {
        return this.resourceLocation;
    }

    public String getLangName() {
        return String.format("config.%s.%s", this.resourceLocation.m_135827_(), this.resourceLocation.m_135815_());
    }

    public String modID() {
        return this.getDefinition().modId();
    }

    public T get() {
        return this.config;
    }
}

