/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.model.client.animation.states;

import me.pandamods.pandalib.api.model.client.animation.Animatable;
import me.pandamods.pandalib.api.model.client.animation.AnimatableInstance;
import me.pandamods.pandalib.api.model.client.animation.states.State;
import me.pandamods.pandalib.api.model.resource.model.Model;
import me.pandamods.pandalib.api.model.resource.model.Node;
import org.joml.Matrix4fc;

public interface AnimationController<T extends Animatable> {
    public State registerStates(T var1);

    default public void animate(T t, Model model, float partialTick) {
        AnimatableInstance instance = t.getAnimatableInstance();
        State state = instance.getState();
        if (state == null) {
            state = this.registerStates(t);
            instance.setState(state);
        }
        if (state == null) {
            throw new NullPointerException("Animation state is NULL");
        }
        state.updateTime(instance, partialTick);
        state.checkStateSwitch(instance);
        for (Node node : model.getNodes()) {
            this.processBoneTransform(node, instance);
        }
    }

    default public void processBoneTransform(Node node, AnimatableInstance instance) {
        node.getRelativeTransform().set((Matrix4fc)instance.getState().getBoneTransform(node));
    }
}

