/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.model.client.animation.states;

import me.pandamods.pandalib.api.model.client.animation.AnimatableInstance;
import me.pandamods.pandalib.api.model.client.animation.states.State;
import me.pandamods.pandalib.api.model.resource.AssimpResources;
import me.pandamods.pandalib.api.model.resource.animation.Animation;
import me.pandamods.pandalib.api.model.resource.animation.Channel;
import me.pandamods.pandalib.api.model.resource.model.Node;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AnimationState
extends State {
    private final Animation animation;
    private final boolean loop;

    public AnimationState(ResourceLocation resourceLocation) {
        this(resourceLocation, false);
    }

    public AnimationState(ResourceLocation resourceLocation, boolean loop) {
        this(AssimpResources.getAnimation(resourceLocation), loop);
    }

    public AnimationState(Animation animation, boolean loop) {
        this.animation = animation;
        this.loop = loop;
    }

    @Override
    public Matrix4f getBoneTransform(Node node) {
        Channel channel = this.animation.getChannel(node.getName());
        if (channel != null) {
            return channel.getMatrix(this.getTime());
        }
        return new Matrix4f((Matrix4fc)node.getInitialTransform());
    }

    @Override
    public void updateTime(AnimatableInstance instance, float partialTick) {
        super.updateTime(instance, partialTick);
        if (this.loop && this.isFinished()) {
            this.start(this.getStartTick() + this.getDuration() * 20.0f);
            this.updateTime(instance, partialTick);
        }
    }

    @Override
    public float getDuration() {
        return this.animation.getDuration();
    }
}

