/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.model.client.animation.states;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.pandamods.pandalib.api.model.client.animation.AnimatableInstance;
import me.pandamods.pandalib.api.model.client.animation.states.TransitionState;
import me.pandamods.pandalib.api.model.resource.model.Node;
import org.joml.Matrix4f;
import oshi.util.tuples.Pair;

public abstract class State {
    private final List<Pair<Supplier<Boolean>, State>> nextStates = new ObjectArrayList();
    private float startTick = 0.0f;
    private float time = 0.0f;

    public void start(float startTick) {
        this.startTick = startTick;
        this.time = 0.0f;
    }

    public void checkStateSwitch(AnimatableInstance instance) {
        for (Pair<Supplier<Boolean>, State> nextState : this.nextStates) {
            if (!((Boolean)((Supplier)nextState.getA()).get()).booleanValue()) continue;
            instance.setState((State)nextState.getB());
        }
    }

    public abstract Matrix4f getBoneTransform(Node var1);

    public void updateTime(AnimatableInstance instance, float partialTick) {
        this.time = (instance.getTick(partialTick) - this.startTick) / 20.0f;
    }

    public float getStartTick() {
        return this.startTick;
    }

    public float getTime() {
        return this.time;
    }

    public boolean isFinished() {
        return this.time >= this.getDuration();
    }

    public abstract float getDuration();

    public void nextState(Supplier<Boolean> condition, State state) {
        this.nextStates.add((Pair<Supplier<Boolean>, State>)new Pair(condition, (Object)state));
    }

    public void nextTransitionState(Supplier<Boolean> condition, State state, float duration) {
        this.nextState(condition, new TransitionState(this, state, duration));
    }
}

