/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.model.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.List;
import java.util.function.Function;
import me.pandamods.pandalib.api.model.resource.model.Mesh;
import me.pandamods.pandalib.api.model.resource.model.Model;
import me.pandamods.pandalib.api.model.resource.model.Node;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelRenderer {
    public static void render(Model model, PoseStack poseStack, int overlayUV, int lightmapUV, Function<String, VertexConsumer> vertexConsumerProvider) {
        List<Mesh> meshes = model.getMeshes();
        ModelRenderer.renderNode(model, model.getRootNode(), poseStack, overlayUV, lightmapUV, vertexConsumerProvider, meshes);
    }

    public static void renderNode(Model model, Node node, PoseStack poseStack, int overlayUV, int lightmapUV, Function<String, VertexConsumer> vertexConsumerProvider, List<Mesh> meshes) {
        if (node.isVisible()) {
            for (Integer meshIndex : node.getMeshIndexes()) {
                Mesh mesh = meshes.get(meshIndex);
                ModelRenderer.renderMesh(model, mesh, node, poseStack, overlayUV, lightmapUV, vertexConsumerProvider.apply(mesh.getMaterialName()));
            }
        }
        node.getChildren().forEach(child -> ModelRenderer.renderNode(model, child, poseStack, overlayUV, lightmapUV, vertexConsumerProvider, meshes));
    }

    public static void renderMesh(Model model, Mesh mesh, Node meshNode, PoseStack poseStack, int overlayUV, int lightmapUV, VertexConsumer vertexConsumer) {
        Vector2f uvCoords = new Vector2f();
        Vector3f position = new Vector3f();
        Vector3f normal = new Vector3f();
        int[] nArray = mesh.getIndices();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            float posX = mesh.getVertices()[i2 * 3];
            float posY = mesh.getVertices()[i2 * 3 + 1];
            float posZ = mesh.getVertices()[i2 * 3 + 2];
            position.set(posX, posY, posZ).mulPosition((Matrix4fc)meshNode.getGlobalTransform());
            float u = mesh.getUvs()[i2 * 2];
            float v = mesh.getUvs()[i2 * 2 + 1];
            uvCoords.set(u, v);
            float normX = mesh.getNormals()[i2 * 3];
            float normY = mesh.getNormals()[i2 * 3 + 1];
            float normZ = mesh.getNormals()[i2 * 3 + 2];
            normal.set(normX, normY, normZ).mulDirection((Matrix4fc)meshNode.getGlobalTransform());
            if (mesh.getBoneIndices() != null && mesh.getBoneWeights() != null) {
                Vector3f finalPosition = new Vector3f();
                Vector3f finalNormal = new Vector3f();
                boolean hasWeights = false;
                for (int j = 0; j < 4; ++j) {
                    int boneIndex = mesh.getBoneIndices()[i2 * 4 + j];
                    float boneWeight = mesh.getBoneWeights()[i2 * 4 + j];
                    if (boneIndex == -1 || boneWeight == 0.0f) continue;
                    hasWeights = true;
                    Node boneNode = model.getNodes().get(boneIndex);
                    Matrix4f boneTransform = boneNode.getGlobalTransform();
                    Matrix4f inverseBoneTransform = new Matrix4f((Matrix4fc)boneNode.getInitialGlobalTransform()).invert();
                    Vector3f bonePosition = new Vector3f((Vector3fc)position).mulPosition((Matrix4fc)inverseBoneTransform).mulPosition((Matrix4fc)boneTransform);
                    Vector3f boneNormal = new Vector3f((Vector3fc)normal).mulDirection((Matrix4fc)inverseBoneTransform).mulDirection((Matrix4fc)boneTransform);
                    finalPosition.add((Vector3fc)bonePosition.mul(boneWeight));
                    finalNormal.add((Vector3fc)boneNormal.mul(boneWeight));
                }
                if (hasWeights) {
                    position.set((Vector3fc)finalPosition);
                    normal.set((Vector3fc)finalNormal);
                }
            }
            vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), position.x(), position.y(), position.z()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uvCoords.x(), uvCoords.y()).m_86008_(overlayUV).m_85969_(lightmapUV).m_252939_(poseStack.m_85850_().m_252943_(), normal.x(), normal.y(), normal.z()).m_5752_();
        }
    }

    public static void renderModelDebug(Model model, PoseStack poseStack, MultiBufferSource bufferSource) {
        model.getNodes().forEach(node -> ModelRenderer.renderNodeDebug(node, poseStack, bufferSource));
    }

    private static void renderNodeDebug(Node node, PoseStack poseStack, MultiBufferSource bufferSource) {
        poseStack.m_85836_();
        poseStack.m_252931_(node.getGlobalTransform());
        float length = 0.9f;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_269399_((double)1.0));
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.m_193479_(Color.green.getRGB());
        vertexConsumer.m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, length, 0.0f);
        vertexConsumer.m_193479_(Color.green.getRGB());
        vertexConsumer.m_5752_();
        vertexConsumer = bufferSource.m_6299_(RenderType.m_269399_((double)1.0));
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.m_193479_(Color.red.getRGB());
        vertexConsumer.m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), length, 0.0f, 0.0f);
        vertexConsumer.m_193479_(Color.red.getRGB());
        vertexConsumer.m_5752_();
        vertexConsumer = bufferSource.m_6299_(RenderType.m_269399_((double)1.0));
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.m_193479_(Color.blue.getRGB());
        vertexConsumer.m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, length);
        vertexConsumer.m_193479_(Color.blue.getRGB());
        vertexConsumer.m_5752_();
        poseStack.m_85849_();
    }
}

