/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.model.resource;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.pandamods.assimp.AIAnimation;
import me.pandamods.assimp.AIScene;
import me.pandamods.assimp.Assimp;
import me.pandamods.pandalib.api.model.resource.animation.Animation;
import me.pandamods.pandalib.api.model.resource.loader.AnimationLoader;
import me.pandamods.pandalib.api.model.resource.loader.ModelLoader;
import me.pandamods.pandalib.api.model.resource.model.Model;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class AssimpResources
implements PreparableReloadListener {
    private static Map<ResourceLocation, Model> MODELS = new Object2ObjectOpenHashMap();
    private static Map<ResourceLocation, Animation> ANIMATIONS = new Object2ObjectOpenHashMap();

    public static Model getModel(ResourceLocation resourceLocation) {
        Model model = MODELS.get(resourceLocation);
        if (model == null) {
            model = new Model();
            MODELS.put(resourceLocation, model);
        }
        return model;
    }

    public static Animation getAnimation(ResourceLocation resourceLocation) {
        Animation animation = ANIMATIONS.get(resourceLocation);
        if (animation == null) {
            animation = new Animation();
            ANIMATIONS.put(resourceLocation, animation);
        }
        return animation;
    }

    @NotNull
    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        ObjectArrayList scenes = new ObjectArrayList();
        Object2ObjectOpenHashMap models = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap();
        CompletableFuture[] completableFutureArray = new CompletableFuture[1];
        completableFutureArray[0] = this.loadAssimpScene(backgroundExecutor, resourceManager, ((List)scenes)::add, ((Map)models)::put, ((Map)animations)::put);
        return ((CompletableFuture)CompletableFuture.allOf(completableFutureArray).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(arg_0 -> AssimpResources.lambda$reload$0((Map)models, (Map)animations, (List)scenes, arg_0), gameExecutor);
    }

    private CompletableFuture<Void> loadAssimpScene(Executor executor, ResourceManager resourceManager, Consumer<AIScene> addScene, BiConsumer<ResourceLocation, Model> putModel, BiConsumer<ResourceLocation, Animation> putAnimation) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.m_214159_("assimp", resource -> true), executor).thenApplyAsync(resources -> {
            HashMap<ResourceLocation, CompletableFuture<AIScene>> sceneTasks = new HashMap<ResourceLocation, CompletableFuture<AIScene>>();
            for (ResourceLocation resourceLocation : resources.keySet()) {
                AIScene scene = this.loadAssimpScene(resourceManager, resourceLocation);
                addScene.accept(scene);
                if (scene == null) continue;
                sceneTasks.put(resourceLocation, CompletableFuture.supplyAsync(() -> scene, executor));
            }
            return sceneTasks;
        }, executor)).thenAcceptAsync(resource -> {
            for (Map.Entry entry : resource.entrySet()) {
                ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
                AIScene scene = (AIScene)((Object)((Object)((CompletableFuture)entry.getValue()).join()));
                Model model = ModelLoader.loadScene(AssimpResources.getModel(resourceLocation), scene);
                putModel.accept(resourceLocation, model);
                for (int i = 0; i < scene.mNumAnimations(); ++i) {
                    AIAnimation aiAnimation = AIAnimation.create(scene.mAnimations().get(i));
                    ResourceLocation animationLocation = resourceLocation;
                    if (scene.mNumAnimations() > 1) {
                        animationLocation = animationLocation.m_266382_("/" + aiAnimation.mName().dataString());
                    }
                    Animation animation = AnimationLoader.loadAnimation(AssimpResources.getAnimation(animationLocation), aiAnimation);
                    putAnimation.accept(animationLocation, animation);
                }
            }
        }, executor);
    }

    private AIScene loadAssimpScene(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        AIScene aIScene;
        block8: {
            InputStream inputStream = resourceManager.m_215593_(resourceLocation).m_215507_();
            try {
                byte[] bytes = inputStream.readAllBytes();
                ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
                buffer.put(bytes);
                buffer.flip();
                aIScene = Assimp.aiImportFileFromMemory(buffer, 16904, "");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(new FileNotFoundException(resourceLocation.toString()));
                }
            }
            inputStream.close();
        }
        return aIScene;
    }

    private static /* synthetic */ void lambda$reload$0(Map models, Map animations, List scenes, Void unused) {
        MODELS = models;
        ANIMATIONS = animations;
        scenes.forEach(Assimp::aiReleaseImport);
    }
}

