/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.model.resource.animation;

import java.util.List;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record Channel(String name, List<Key<Vector3fc>> positionKeys, List<Key<Quaternionfc>> rotationKeys, List<Key<Vector3fc>> scalingKeys) {
    public Vector3fc interpolatePosition(float time) {
        if (this.positionKeys.isEmpty()) {
            return new Vector3f();
        }
        List<Key<Vector3fc>> keys = this.positionKeys();
        for (int i = 0; i < keys.size() - 1; ++i) {
            Key<Vector3fc> key1 = keys.get(i);
            Key<Vector3fc> key2 = keys.get(i + 1);
            if (!(key1.time() <= time) || !(key2.time() >= time)) continue;
            float keyDuration = key2.time() - key1.time();
            float interpolatedTime = (time - key1.time()) / keyDuration;
            return key1.value().lerp(key2.value(), interpolatedTime, new Vector3f());
        }
        return keys.get(keys.size() - 1).value();
    }

    public Quaternionfc interpolateRotation(float time) {
        if (this.rotationKeys.isEmpty()) {
            return new Quaternionf();
        }
        List<Key<Quaternionfc>> keys = this.rotationKeys();
        for (int i = 0; i < keys.size() - 1; ++i) {
            Key<Quaternionfc> key1 = keys.get(i);
            Key<Quaternionfc> key2 = keys.get(i + 1);
            if (!(key1.time() <= time) || !(key2.time() >= time)) continue;
            float keyDuration = key2.time() - key1.time();
            float interpolatedTime = (time - key1.time()) / keyDuration;
            return key1.value().nlerp(key2.value(), interpolatedTime, new Quaternionf());
        }
        return keys.get(keys.size() - 1).value();
    }

    public Vector3fc interpolateScale(float time) {
        if (this.scalingKeys.isEmpty()) {
            return new Vector3f(1.0f);
        }
        List<Key<Vector3fc>> keys = this.scalingKeys();
        for (int i = 0; i < keys.size() - 1; ++i) {
            Key<Vector3fc> key1 = keys.get(i);
            Key<Vector3fc> key2 = keys.get(i + 1);
            if (!(key1.time() <= time) || !(key2.time() >= time)) continue;
            float keyDuration = key2.time() - key1.time();
            float interpolatedTime = (time - key1.time()) / keyDuration;
            return key1.value().lerp(key2.value(), interpolatedTime, new Vector3f());
        }
        return keys.get(keys.size() - 1).value();
    }

    public Matrix4f getMatrix(float time, Matrix4f dist) {
        dist.identity();
        dist.translate(this.interpolatePosition(time));
        dist.rotate(this.interpolateRotation(time));
        dist.scale(this.interpolateScale(time));
        return dist;
    }

    public Matrix4f getMatrix(float time) {
        return this.getMatrix(time, new Matrix4f());
    }

    public record Key<T>(float time, T value) {
    }
}

