/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.model.resource.loader;

import java.util.ArrayList;
import java.util.Iterator;
import me.pandamods.assimp.AIAnimation;
import me.pandamods.assimp.AINodeAnim;
import me.pandamods.assimp.AIQuatKey;
import me.pandamods.assimp.AIQuaternion;
import me.pandamods.assimp.AIVector3D;
import me.pandamods.assimp.AIVectorKey;
import me.pandamods.pandalib.api.model.resource.animation.Animation;
import me.pandamods.pandalib.api.model.resource.animation.Channel;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.Struct;

public class AnimationLoader {
    public static Animation loadAnimation(Animation animation, AIAnimation aiAnimation) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (int i = 0; i < aiAnimation.mNumChannels(); ++i) {
            AIVector3D vector;
            Struct key;
            AINodeAnim aiNodeAnim = AINodeAnim.create(aiAnimation.mChannels().get(i));
            ArrayList<Channel.Key<Vector3fc>> positionKeys = new ArrayList<Channel.Key<Vector3fc>>();
            ArrayList<Channel.Key<Quaternionfc>> rotationKeys = new ArrayList<Channel.Key<Quaternionfc>>();
            ArrayList<Channel.Key<Vector3fc>> scalingKeys = new ArrayList<Channel.Key<Vector3fc>>();
            Iterator iterator = aiNodeAnim.mPositionKeys().iterator();
            while (iterator.hasNext()) {
                key = (AIVectorKey)((Object)iterator.next());
                vector = key.mValue();
                positionKeys.add(new Channel.Key<Vector3f>((float)(key.mTime() / aiAnimation.mTicksPerSecond()), new Vector3f(vector.x(), vector.y(), vector.z())));
            }
            iterator = aiNodeAnim.mRotationKeys().iterator();
            while (iterator.hasNext()) {
                key = (AIQuatKey)((Object)iterator.next());
                AIQuaternion quaternion = key.mValue();
                rotationKeys.add(new Channel.Key<Quaternionf>((float)(key.mTime() / aiAnimation.mTicksPerSecond()), new Quaternionf(quaternion.x(), quaternion.y(), quaternion.z(), quaternion.w())));
            }
            iterator = aiNodeAnim.mScalingKeys().iterator();
            while (iterator.hasNext()) {
                key = (AIVectorKey)((Object)iterator.next());
                vector = key.mValue();
                scalingKeys.add(new Channel.Key<Vector3f>((float)(key.mTime() / aiAnimation.mTicksPerSecond()), new Vector3f(vector.x(), vector.y(), vector.z())));
            }
            channels.add(new Channel(aiNodeAnim.mNodeName().dataString(), positionKeys, rotationKeys, scalingKeys));
        }
        float duration = (float)(aiAnimation.mDuration() / aiAnimation.mTicksPerSecond());
        return animation.set(channels, duration);
    }
}

