/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.model.resource.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import me.pandamods.assimp.AIBone;
import me.pandamods.assimp.AIFace;
import me.pandamods.assimp.AIMaterial;
import me.pandamods.assimp.AIMesh;
import me.pandamods.assimp.AINode;
import me.pandamods.assimp.AIScene;
import me.pandamods.assimp.AIString;
import me.pandamods.assimp.AIVector3D;
import me.pandamods.assimp.AIVertexWeight;
import me.pandamods.assimp.Assimp;
import me.pandamods.pandalib.api.model.resource.model.Mesh;
import me.pandamods.pandalib.api.model.resource.model.Model;
import me.pandamods.pandalib.api.model.resource.model.Node;
import me.pandamods.pandalib.utils.AssimpUtils;

public class ModelLoader {
    public static Model loadScene(Model model, AIScene scene) {
        int i;
        ArrayList<Mesh> meshes = new ArrayList<Mesh>();
        ArrayList<String> materials = new ArrayList<String>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node rootNode = ModelLoader.buildNodeTree(scene.mRootNode(), null, nodes);
        for (i = 0; i < scene.mNumMaterials(); ++i) {
            AIMaterial material = AIMaterial.create(scene.mMaterials().get(i));
            AIString materialName = AIString.create();
            Assimp.aiGetMaterialString(material, "?mat.name", 0, 0, materialName);
            String materialNameStr = materialName.dataString();
            materials.add(materialNameStr);
        }
        for (i = 0; i < scene.mNumMeshes(); ++i) {
            AIMesh aiMesh = AIMesh.create(scene.mMeshes().get(i));
            Mesh mesh = ModelLoader.processMesh(aiMesh, materials, nodes);
            meshes.add(mesh);
        }
        return model.set(rootNode, meshes, nodes);
    }

    public static Node buildNodeTree(AINode aiNode, Node parent, List<Node> nodes) {
        int i;
        String name = aiNode.mName().dataString();
        Node node = new Node(name, AssimpUtils.toMatrix4f(aiNode.mTransformation()), parent);
        nodes.add(node);
        for (i = 0; i < aiNode.mNumMeshes(); ++i) {
            node.getMeshIndexes().add(aiNode.mMeshes().get(i));
        }
        for (i = 0; i < aiNode.mNumChildren(); ++i) {
            AINode childNode = AINode.create(aiNode.mChildren().get(i));
            ModelLoader.buildNodeTree(childNode, node, nodes);
        }
        return node;
    }

    public static Mesh processMesh(AIMesh aiMesh, List<String> materials, List<Node> nodes) {
        int[] indices = ModelLoader.processIndices(aiMesh);
        float[] vertices = ModelLoader.processVertices(aiMesh);
        float[] uvs = ModelLoader.processUVCoords(aiMesh);
        float[] normals = ModelLoader.processNormals(aiMesh);
        int[] boneIndices = new int[vertices.length / 3 * 4];
        float[] boneWeights = new float[vertices.length / 3 * 4];
        ModelLoader.processBones(aiMesh, nodes, boneIndices, boneWeights);
        return new Mesh(indices, vertices, uvs, normals, boneIndices, boneWeights, materials.get(aiMesh.mMaterialIndex()));
    }

    private static int[] processIndices(AIMesh aiMesh) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        Iterator iterator = aiMesh.mFaces().iterator();
        while (iterator.hasNext()) {
            AIFace face = (AIFace)((Object)iterator.next());
            for (int i = 0; i < face.mNumIndices(); ++i) {
                indices.add(face.mIndices().get(i));
            }
        }
        return indices.stream().mapToInt(Integer::intValue).toArray();
    }

    private static float[] processVertices(AIMesh aiMesh) {
        AIVector3D.Buffer buffer = aiMesh.mVertices();
        float[] data = new float[buffer.remaining() * 3];
        int pos = 0;
        while (buffer.remaining() > 0) {
            AIVector3D vector = (AIVector3D)buffer.get();
            data[pos++] = vector.x();
            data[pos++] = vector.y();
            data[pos++] = vector.z();
        }
        return data;
    }

    private static float[] processUVCoords(AIMesh aiMesh) {
        AIVector3D.Buffer buffer = aiMesh.mTextureCoords(0);
        float[] data = new float[buffer.remaining() * 2];
        int pos = 0;
        while (buffer.remaining() > 0) {
            AIVector3D vector = (AIVector3D)buffer.get();
            data[pos++] = vector.x();
            data[pos++] = 1.0f - vector.y();
        }
        return data;
    }

    private static float[] processNormals(AIMesh aiMesh) {
        AIVector3D.Buffer buffer = aiMesh.mNormals();
        float[] data = new float[buffer.remaining() * 3];
        int pos = 0;
        while (buffer.remaining() > 0) {
            AIVector3D vector = (AIVector3D)buffer.get();
            data[pos++] = vector.x();
            data[pos++] = vector.y();
            data[pos++] = vector.z();
        }
        return data;
    }

    private static void processBones(AIMesh aiMesh, List<Node> nodes, int[] boneIndices, float[] boneWeights) {
        Arrays.fill(boneIndices, -1);
        Arrays.fill(boneWeights, 0.0f);
        for (int i = 0; i < aiMesh.mNumBones(); ++i) {
            AIBone aiBone = AIBone.create(aiMesh.mBones().get(i));
            Node boneNode = ModelLoader.findNode(aiBone.mNode(), nodes);
            block1: for (int j = 0; j < aiBone.mNumWeights(); ++j) {
                AIVertexWeight aiVertexWeight = (AIVertexWeight)aiBone.mWeights().get(j);
                int vertexId = aiVertexWeight.mVertexId();
                float weight = aiVertexWeight.mWeight();
                for (int k = 0; k < 4; ++k) {
                    if (boneWeights[vertexId * 4 + k] != 0.0f) continue;
                    boneIndices[vertexId * 4 + k] = nodes.indexOf(boneNode);
                    boneWeights[vertexId * 4 + k] = weight;
                    continue block1;
                }
            }
        }
    }

    private static Node findNode(AINode aiNode, List<Node> nodes) {
        for (Node node : nodes) {
            if (!AssimpUtils.AINodeEqualsNode(aiNode, node)) continue;
            return node;
        }
        return null;
    }
}

